/*
   File: symbol_table.h
   Stores symbols with their segment type and 64 bit value

   Copyright 2009-2010 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncSymbolTable
#define IncSymbolTable

/* libabase include */
#include <abase_porting.h>

/* local includes */
#include "acoder.h"

/* Introduce a symbol as an opaque type */
typedef struct symbol_rec *symbol;

/* Operations of the symbol table */
int enter_symbol (char *sy, symbol *entry);
int lookup_symbol (char *sy, symbol *entry);
void get_symbol_info (symbol sy, segment *segment, int64 *value);
void update_symbol_info (symbol sy, segment segment, int64 value);
void init_symbol_table ();
void dump_symbol_table ();
void ddump_symbol_table ();

#endif /* IncSymbolTable */
