/*
   File: acoder.h
   Generates agfl object code in various segments

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncACoder
#define IncACoder

/* Libabase includes */
#include <abase_porting.h>

/* Local includes */
#include "lexer.h"
#include "opcode.h"

/* Define the available segments */
#define MAX_SEGS 6
typedef enum
{ abs_segment, code_segment, interface_segment,
  data_segment, rotext_segment, error_segment,
} segment;

/* Define a structure for an operand and an instruction */
typedef struct operand_rec
{ token tk;
  segment seg;
  int64 value;
  char *svalue;
} operand;

/* Define a structure for an opcode with its operands */
#define MAX_OPNDS 4
typedef struct instr_rec
{ opcode opc;
  int nr_opnds;
  operand opnds[MAX_OPNDS];
} instr;

/* Exported routines */
char *string_from_segment (segment seg);
void get_current_location (segment *ret_seg, int64 *ret_value);
void set_current_segment (segment seg);
void code_empty_instruction ();
void code_instruction (instr *ins);
void code_word (operand *opnd);
void code_string (operand *opnd);
int init_acoder ();
void finish_acoder ();

#endif /* ACoder */
