/*
   File: lxcn_search.h
   Interface definitions for the lexicon search routines.

   Copyright 2007 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lxcn_search.h,v 1.4 2009/01/27 17:06:43 olafs Exp $"
*/
#ifndef IncLxcnSearch
#define IncLxcnSearch

#include "lxcn_input.h"
#include "lxcn_lexicon.h"

#ifdef  __cplusplus
extern "C" {
#endif

/* Temporary inclusion of max_edit_distance variable: should become hidden */
extern int max_edit_distance;

/* Introduce LexiconIterator as an opaque struct pointer */
typedef struct lexicon_iterator_rec *LexiconIterator;

/* Matching of grammar terminals */
char *lxcn_match_lexeme (char *input, char *lexeme, LexemeType *lex_type, int *penalty);

/* Matching of lexicon terminals, using an iterator over the lexicon */
LexiconIterator lxcn_init_lexicon_match (char *input, Lexicon lexicon);
char *lxcn_next_lexicon_match (LexiconIterator iter);
void lxcn_finish_lexicon_match (LexiconIterator iter);
void lxcn_get_lexicon_match_info (LexiconIterator iter, int *entry_nr,
				  char **matched_lexeme, LexemeType *matched_marker,
				  int *penalty);

#ifdef  __cplusplus
}
#endif

#endif /* IncLxcnSearch */
