/*
   File: arts_posmemo.h
   Routine definitions for positive memoisation

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: arts_posmemo.h,v 1.4 2008/12/03 14:52:17 marcs Exp $"
*/
#ifndef IncArtsPosmemo
#define IncArtsPosmemo

#include <assert.h>

/* Include Arts datastructures */
#include "arts_ds.h"

/* Allocation */
void posmemo_init ();
void posmemo_done ();
void posmemo_free_vec (PosMemo* entry);
void posmemo_dump_table (Trellis* trellis);
void posmemo_init_table_entry (PosMemo* entry);

/* Access functions */
int posmemo_is_unknown (StateIndicator input_state, int nont_nr);
int posmemo_is_known (StateIndicator input_state, int nont_nr);
int posmemo_is_blocked (StateIndicator input_state, int nont_nr);
int posmemo_is_unblocked (StateIndicator input_state, int nont_nr);
void posmemo_set_unknown (StateIndicator input_state, int nont_nr);
void posmemo_set_blocked (StateIndicator input_state, int nont_nr);

/* Posmemo handling */
int posmemo_add_production (StateIndicator input_state, int nont_nr, Penalty penalty,
			    int nr_formals, int nr_variables, int nr_sons,
			    Value *variables, StateIndicator target_state, void *pass2);
void* posmemo_get_pass2 (PosMemo prod);
void* posmemo_get_formal_ptr (PosMemo state);
Value posmemo_get_variable (PosMemo state, int nr);
Value posmemo_get_local (PosMemo state, int nr);
PosMemo posmemo_get_son (PosMemo state, int nr);
Penalty posmemo_get_penalty (PosMemo state);
PosMemo posmemo_get_next_prod (PosMemo curr);
StateIndicator posmemo_get_input_state (PosMemo curr);
PosMemo posmemo_get_prod_ptr (StateIndicator input_state, int nont_nr);
int posmemo_count_prod (StateIndicator input_state, int nont_nr);
void posmemo_rdump_pmprod (PosMemo pm_prod, int indent);

#endif /* IncArtsPosmemo */
