/*
   File: lxcn_vocabulary.h
   Stores a vocabulary (by which we mean the datastructure through which
   words can be entered with their appropriate information) for later
   retrieval. Since the number of words in the vocabulary may easily be
   of the order of one million, words are stored in a trie structure.

   Copyright 2007 Radboud University of Nijmegen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 

   CVS ID: "$Id: lxcn_vocabulary.h,v 1.11 2007/10/17 09:17:31 marcs Exp $"
*/
#ifndef IncLxcnVocabulary
#define IncLxcnVocabulary

#ifdef __cplusplus
extern "C" {
#endif

/* libabase includes */
#include <abase_fileutil.h>

/*
   Export Vocabulary as opaque struct pointer with access routines
*/
typedef struct voc_trie_rec *Vocabulary;
#define vocabulary_nil ((Vocabulary) NULL)

/* exported routines */
int *lxcn_enter_into_vocabulary (Vocabulary *voc, char *pattern);
int *lxcn_lookup_in_vocabulary (Vocabulary voc, char *pattern);
void lxcn_dump_vocabulary (Vocabulary voc);
void lxcn_bin_save_trie (BinFile bf, Vocabulary voc);
void lxcn_bin_save_vocabulary (char *path, Vocabulary voc);
void lxcn_bin_load_trie (BinFile bf, Vocabulary *voc);
void lxcn_bin_load_vocabulary (char *path, Vocabulary *voc);
void lxcn_free_vocabulary (Vocabulary voc);

/* exported iterator */
typedef void (*VocIterProc)(void *arg, char *key, int info);
void lxcn_iterate_over_vocabulary (Vocabulary voc, VocIterProc vip, void *arg);

#ifdef __cplusplus
}
#endif
#endif /* IncLxcnVocabulary */
