/*
 * $Id: lxcn_voc_iterator.h,v 1.3 2008/03/05 16:34:53 olafs Exp $
 *
 * An iterator over a Vocabulary.
 *
 * Typical use:
 *
    void
    dump_trie(Vocabulary voc)
    {
	struct VocStack *stack;
	char *key;
	int *info;
	int more;

	stack = lxcn_start_iteration(voc);
	more = lxcn_first_iteration(stack, &key, &info);
	while (more) {
	    fprintf(stderr, "%s -> %d\n", key, *info);
	    abs_free(key, "key");
	    more = lxcn_next_iteration(stack, &key, &info);
	}
	lxcn_end_iteration(stack);
    }
 */

struct VocStack;

struct VocStack *lxcn_start_iteration(Vocabulary t);
void lxcn_end_iteration(struct VocStack *stack);
int lxcn_first_iteration(struct VocStack *stack, char **search_key, int **info);
int lxcn_next_iteration(struct VocStack *stack, char **search_key, int **info);

struct VocBinIter;

struct VocBinIter *lxcn_bin_start_iteration(char *path);
void lxcn_bin_end_iteration(struct VocBinIter *vi);
int lxcn_bin_next_iteration(struct VocBinIter *vi, char **search_key, int *info);
