/*
   File: abase_warshall.c
   Implements Warshalls algorithm
  
   CVS ID: "$Id: abase_warshall.c,v 1.1 2007/04/18 15:09:41 marcs Exp $"
*/

/* general includes */
#include <stdio.h>

/* local includes */
#include "abase_memalloc.h"
#include "abase_warshall.h"

char *abs_warshall (int n, char *rel)
	{ /* Allocate array for result relation */
	  char *result = (char *) abs_calloc (n*n, sizeof (char), "abs_warshall");
	  int i,j,k;

	  /* Copy the original relation into the result */
	  for (i=0; i<n; i++)
	     for (j=0; j<n; j++) result[i * n + j] = rel[i * n + j];

	  /* Take closure */
	  for (k=0; k<n; k++)
	     for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		   result[i * n + j] = result[i * n + j] ||
			(result[i * n + k] && result [k * n + j]);

	  return (result);
	};
