/*
   File: opt.c

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: opt.c,v 1.10 2006/09/27 16:01:35 marcs Exp $
*/

/* standard includes */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

/* This will have to change: no getopt.h under WIN32 */
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else /* HAVE_GETOPT_H */
#ifdef HAVE_GETOPT
#include <unistd.h>
extern char *optarg;
#endif /* HAVE_GETOPT */
#endif /* HAVE_GETOPT_H */

/* libabase includes */
#include <abase_error.h>

#include "opt.h"

static char *name = NULL;
static char *lexicon_file_name = NULL;

int max_edit_distance = ED;
int verbose = 0;
int with_edit_distance_list = 0;
int with_c = 0;
int with_d = 0;
int with_l = 0;
int with_p = 0;

static void
put_name (char *n)
{
#ifdef WIN32
    int len;

    len = strlen(n);
    if (len > 4 && strcasecmp(n + len - 4, ".exe") == 0)
       name[len - 4] = '\0';
#endif
   name = n;
}

char *get_name (void)
{ return name;
}

char *get_lexicon_file_name (void)
{ return lexicon_file_name;
}

/*-----------------------------------
// -h shows options
//---------------------------------*/
static void display_help ()
{
    abs_message ("USAGE: %s [OPTIONS] lecicon_file\n", get_name());
    abs_message (
        "OPTION      DEFAULT     PURPOSE\n"
	"-E number   %2d         maximum edit distance\n"
        "-c          off         generate lxlxd cube\n"
        "-d          off         generate length versus distance table\n"
        "-l          off         generate length versus length table\n" 
        "-p          off         generate lxlxd binary table\n"
        "-v          off         be verbose\n"
        "-h          off         show this help\n",
        ED); /* for -E */
}

void process_command_line(int argc, char* argv[])
{
    char c;
    int hflg = 0;
    int n;
    char* opt_str = ":hvE:cdlp";

    put_name(argv[0]);

    while ((c = getopt(argc, argv, opt_str)) != EOF) {
        switch (c) {
            case 'E':
		n = atoi(optarg);
		if ((n >= 0) && (n <= ED)) max_edit_distance = n;
                else if (n < 0) abs_warning ("negative edit distance, ignored");
                else abs_warning ("edit distance greater than %d (max), ignored", ED);
		break;
            case 'c': with_c = 1;  break;
            case 'd': with_d = 1;  break;
            case 'l': with_l = 1;  break;
            case 'p': with_p = 1;  break;
            case 'v': verbose = 1; break;
            case '?': hflg++;      break;
            case 'h': hflg++;      break;
            default:
                abs_fatal ("unknown option '-%c', use '%s -h' for help", c, get_name());
        }
    }

    if (hflg) {
        display_help();
        abs_exit (0);
    }

    if  (optind == argc - 1) lexicon_file_name = argv[optind]; 
    else abs_fatal ("no or too many lexicon file names, use '%s -h' for help", get_name());
}
