/*
   File: lxcn_test_lex.c
   Simple test program to check reading and searching lexica

   Copyright 2007 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lxcn_test_lex.c,v 1.2 2007/10/31 14:58:17 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libabase includes */
#include <abase_porting.h>
#include <abase_fileutil.h>
#include <abase_meminfo.h>
#include <abase_error.h>

/* local includes */
#include "lxcn_input.h"
#include "lxcn_lexicon.h"
#include "lxcn_search.h"

static void test_lexicon (NewLexicon lex, char *input)
{ char *inp = input;
  char *end;
  LexemeType type;
  LexiconIterator iter;
  while (lxcn_is_blank (*inp)) inp++;
  if ((*inp) == '-')
    { inp++; type = Suffix;
    };
  iter = lxcn_init_lexicon_match (inp, lex);
  while ((end = lxcn_next_lexicon_match (iter)) != NULL)
    { int entry_nr, nr_of_entries, ix;
      int *entries;
      char *lexeme;
      char *ptr;
      lxcn_get_lexicon_match_info (iter, &entry_nr, &lexeme, &type);
      nr_of_entries = lxcn_get_entries_from_nr (lex, entry_nr, &entries);
      abs_printf ("Matched lexeme type %d & string: ", type);
      for (ptr = input; ptr != end; ptr++) abs_printf ("%c", *ptr);
      abs_printf ("\n");
      abs_printf ("Matched entry nr %d, %d entries for lexeme: '", entry_nr, nr_of_entries);
      lxcn_print_lexeme (lexeme);
      abs_printf ("'\n");
      for (ix = 0; ix < nr_of_entries; ix++)
        lxcn_print_entry (lex, entries, ix);
    };
  lxcn_finish_lexicon_match (iter);
}

int main (int argc, char **argv)
{ NewLexicon lex;
  char lex_name[80];
  char buffer[256];
  if (argc > 1) sprintf (lex_name, "%s.blx", argv[1]);
  else sprintf (lex_name, "latin.blx");
  lxcn_init_char_tables (" \t\n\r", "", "",
			 "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz");
  lex = lxcn_read_lexicon (lex_name);
  while (fgets (buffer, 255, stdin) != NULL)
    test_lexicon (lex, buffer);
  abs_report_meminfo ();
}
