/*
   File: lxcn_vocabulary.h
   Stores a vocabulary (by which we mean the datastructure through which
   words can be entered with their appropriate information) for later
   retrieval. Since the number of words in the vocabulary may easily be
   of the order of one million, words are stored in a trie structure.

   Copyright 2007 Radboud University of Nijmegen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 

   CVS ID: "$Id: lxcn_vocabulary_impl.h,v 1.3 2007/10/17 09:17:31 marcs Exp $"
*/
#ifndef IncLxcnVocabularyImpl
#define IncLxcnVocabularyImpl

#ifdef __cplusplus
extern "C" {
#endif

/* libabase includes */
#include "lxcn_vocabulary.h"

/*
   Define the structure of a vocabulary
*/
typedef struct voc_index_tree_rec *VocIndexTree;
typedef struct voc_trie_rec *VocTrie;
typedef int VocInfo;

struct voc_trie_rec
	{ VocIndexTree tails;		/* Balanced tree of subtries */
	  char *search_key;		/* Orig search key */
	  int rem_offset;		/* Tail index in search key */
	  VocInfo info;			/* Associated info: index in feature space */
	};

struct voc_index_tree_rec
	{ VocIndexTree left;		/* Left subtree */
	  VocIndexTree right;		/* Right subtree */
	  VocTrie sub_trie;		/* Associated subtrie */
	  unsigned char key;		/* Search key in index tree */
	  signed char balfac;		/* Balance factor */
	};

/* Introduce nil pointers */
#define voc_index_tree_nil ((VocIndexTree) NULL)
#define voc_trie_nil ((VocTrie) NULL)

#ifdef __cplusplus
}
#endif
#endif /* IncLxcnVocabularyImpl */
