/*
   File: lexicon_search.h
   Interface definitions for the lexicon search library routines.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lexicon_search.h,v 1.12 2007/07/27 19:46:42 marcs Exp $"
*/
#ifndef IncLexiconSearch
#define IncLexiconSearch

#include "lexicon.h"
#include "lxcn_input.h"

#ifdef  __cplusplus
extern "C" {
#endif

/* Introduce TrieData is opaque type */
typedef struct TrieData_rec *TrieData;

/* One globally exported variable */
extern int max_edit_distance;

/* Exported routines */
unsigned char* lxcn_approx_match_trie (Trie trie, TrieData data);
TrieData lxcn_init_approx_match_trie (unsigned char* input, LexemeType lex_type);
void lxcn_exit_approx_match_trie (TrieData trie_data);
unsigned char *lxcn_get_lex_begin (TrieData trie_data);
unsigned char *lxcn_get_lex_end (TrieData trie_data);
int lxcn_get_info (TrieData trie_data);

#ifdef  __cplusplus
}
#endif

#endif /* IncLexiconSearch */
