/*
   File: abase_repr.h
   Defines the representation of affix values, penalties

   Copyright 2006 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_repr.h,v 1.4 2007/06/06 09:20:43 marcs Exp $"
*/
#ifndef IncAbaseRepr
#define IncAbaseRepr

/* Local includes */
#include <abase_porting.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*
   Define the representation of affix values
   Note that this representation is to change when affixes
   become represented by a pointer to a tagged structure.
*/
typedef unsigned long Bitset;
typedef u_int32 Bitset32;	/* The future type for Bitset */
typedef char *Text;
typedef enum
	{ SetKind = 0,
          IntKind = 2,
          TextKind = 4,
	} ValueKind;

typedef union
	{ Bitset set_par;
	  int int_par;
	  char *text_par;
	} Value;

typedef struct
	{ ValueKind kind;
	  Value value;
	} TaggedValue;

typedef int32 Penalty;

#ifdef  __cplusplus
}
#endif
#endif /* IncAbaseRepr */
