// C++ interface to the bison generated parser.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: parserinterface.h,v 1.9 2002/11/07 00:44:02 murphy Exp $

#ifndef PARSERINTERFACE_H
#define PARSERINTERFACE_H

#include <stdio.h>
#include <string>
#include <list>
#include "id.h"
#include "paramtab.h"
#include "entry.h"

typedef list<Param*> MyParamList;

int get_line_nr();
int get_col_nr();
void reset_scanner_counters();
int yyparse();
extern FILE* yyin;
extern char* parser_error;

int no_error_occured();
void set_current_module_name(string curname);
Param* affterms_to_param(IDList* aff_terms);

IDList* aff_terml_new(string* a);
IDList* aff_terml_add(IDList* lst, string* str);

EntryList* nont_def(string* name, pParam pars, long count);

pParam build_params(MyParamList* paraml);

#endif // PARSERINTERFACE_H
