// Implementation of the Options class.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: options.cc,v 1.12 2005/04/14 12:46:41 olafs Exp $

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else /* HAVE_GETOPT_H */
#ifdef HAVE_GETOPT
#include <unistd.h>
#endif /* HAVE_GETOPT */
#endif /* HAVE_GETOPT_H */

using namespace std;
#include <stdlib.h>
#include <string>
#include <iostream>

#include "globals.h"
#include "options.h"

static string const prog_name = "lexgen";
static string const version = "2.0";

void Options::show_synopsis()
{
    cout << "Usage: " << prog_name
	<< " [-f] [-h] [-s] [-T] [-v] [-V] [-o <out-file>] <lif-file>" << endl;
}

void Options::show_help()
{
    cout << "Options are:" << endl
#ifdef HAVE_GETOPT_LONG
	<< "    -h    --help           show help" << endl
	<< "    -v    --verbose        be verbose" << endl
	<< "    -s    --sizes          log output table sizes" << endl
	<< "    -T    --time           log with timestamp" << endl
	<< "    -V    --version        show version" << endl
	<< "    -o    --output         specify output file" << endl
        << "    -f    --force          force compilation" << endl
#else
	<< "    -h                     show help" << endl
	<< "    -v                     be verbose" << endl
	<< "    -s                     log output table sizes" << endl
	<< "    -T                     log with timestamp" << endl
	<< "    -V                     show version" << endl
	<< "    -o                     specify output file" << endl
        << "    -f                     force compilation" << endl
#endif // HAVE_GETOPT_LONG
	<< "Arguments are:" << endl
	<< "    <lif-file>             name of input lif file" << endl
	<< "    <out-file>             name of output file" << endl;
}

void Options::say_hello()
{
  cout	<< "This is " << prog_name << ", version " << version << endl;
}

void Options::show_version()
{
   cout << "This is " << prog_name << ", version " << version << endl;
}

string remove_extension(string str, string ext1)
// Strip extension ext1, where ext1 present.
{
    string res = str;

    if (res.length() > ext1.length()) {
        // (str.compare(ext1, str.length()-ext1.length(), ext1.length()) == 0)
	// Falling back to strcmp() because no suitable compare function
	//	seems to be available for all platforms.
        if (!strcmp(ext1.c_str(), str.c_str() + str.length()-ext1.length())) {
            res.erase(str.length()-ext1.length(), ext1.length());
        }
    }
    return res;
}

Options::Options(int argc, char* const argv[]):
        outfile(""),
        lex_interface_file("")
{
    // Initialize options
    force_compile = false;
    verbose_option = 0;
    log_sizes_option = false;
    log_with_timestamp_option = false;

    int errflg = 0;
    char c;
    char* opt_str = "vsTVo:hf";

#ifdef HAVE_GETOPT_LONG
    int option_index = 0;
    struct option long_options[] = {
        {"verbose", 0, 0, 0},
        {"sizes", 0, 0, 0},
        {"time", 0, 0, 0},
        {"version", 0, 0, 0},
        {"output-file", 2, 0, 'o'},
        {"help", 0, 0, 0},
        {"force", 0, 0, 0},
        {0, 0, 0, 0}
    };

    while ((c = getopt_long(argc, argv, opt_str, long_options, &option_index)) != EOF) {
#else /* do not HAVE_GETOPT_LONG: */
    while ((c = getopt(argc, argv, opt_str)) != EOF) {
#endif
        switch (c) {
            case 'v':
                verbose_option++;
                break;
            case 's':
                log_sizes_option = true;
                break;
            case 'T':
                log_with_timestamp_option = true;
                break;
            case 'V':
                show_version();
                exit(0);
            case 'h':
                show_help();
                exit(0);
            case 'o':
                outfile = string(optarg);
                break;
            case 'f':
                force_compile = true;
                break;
            default:
                errflg++;
                cout << "Unknown option \"" << c << "\"" << endl;
                break;
        }
    }

    if (errflg) {
        show_synopsis();
        exit(1);
    }

    if (optind >= argc) {
        cout << "No lif file specified." << endl;
        exit(1);
    }
    string lex_interface_arg = argv[optind++];
    string lex_basename = remove_extension(lex_interface_arg, lif_ext);

    lex_interface_file = lex_basename + lif_ext;
    if (outfile.length() == 0) {
        outfile = lex_basename + lex_ext;
    }

    // 2002-03-19  pb  next 3 lines with verbose text removed
    // if (verbose_option) {
    //     cout << "output file: \"" << outfile << "\"" << endl;
    // }
}
