/*
   File: arts_lexer.h
   Interface to lexical analysis module.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: arts_lexer.h,v 1.5 2007/09/12 12:58:42 marcs Exp $"
*/
#ifndef IncArtsLexer
#define IncArtsLexer

/* standard includes */
#include <limits.h>

/* libabase includes */
#include <abase_repr.h>

/* liblexicon includes */
#include <lexicon.h>
#include <lxcn_input.h>
#include <lexicon_search.h>

/* Access functions */
Position STATE_POS (StateNode *ind);
StateIndicator GET_FIRST_STATE_INDICATOR (Trellis *trel);

int IS_LASTPART (Transition *t);
Terminal TRANSITION_TERMINAL (Transition *tra);
Value *TRANSITION_PARAMS (Transition* tra);
char *TRANSITION_TEXT (Transition* tra);
Penalty TRANSITION_PENALTY (Transition *tra);

StateNode** GET_TRELLIS_STATE_ROW (Trellis *trel);
StateNode** GET_TRELLIS_PARTS_ROW (Trellis *trel);
Transition* GET_STATE_TRANSLIST (Trellis *trel, StateIndicator i_st, ARG cls);
StateIndicator TRANSITION_DEST_STATE_INDICATOR (Transition *tra, Trellis* trel);

/* Exported functions */
LexemeType get_transition_lex_type (Transition* transition);
StateNode* get_shortest_transition (Trellis *trellis, StateNode *istate);
Trellis* make_trellis_by_word_lexing (char *input, int linenr, int colnr);
void delete_trellis (Trellis* trellis);
void print_trellis (Trellis* trellis);
void show_neg_memo_blocks (Trellis* trellis);
int state_has_eos_transition (StateNode *the_state);
int is_empty_trellis (Trellis* trellis);
void reset_trellis_pos_memos (Trellis *trellis);
void init_lexer ();
void end_lexer ();

#endif /* IncArtsLexer */
