/*
   File: arts_ds.c
   Holds the central datastructure of the abstract machine

   CVS ID: "$Id: arts_ds.c,v 1.3 2007/09/12 12:58:42 marcs Exp $"
*/

/* Standard includes */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

/* libarts includes */
#include "arts_ds.h"

/* Publicly export the interface structure */
struct interface_rec arts_ifd;

void arts_init_ds ()
{ /* Initialize the grammar and filenames */
  arts_ifd.grammar_name = NULL;
  arts_ifd.input_fname = NULL;
  arts_ifd.output_fname = NULL;
  arts_ifd.input_pos_fname = NULL;

  /* The size of the code, data and rotext segment */
  arts_ifd.code_size = 0;
  arts_ifd.data_size = 0;
  arts_ifd.rotext_size = 0;

  /* The three segments */
  arts_ifd.code = NULL;
  arts_ifd.data = NULL;
  arts_ifd.rotext = NULL;

  /* The lexicon */
  arts_ifd.lexicon = NULL;

  /* Interface section */
  arts_ifd.gra_version = 0;
  arts_ifd.nr_lexicon_nonterminals = 0;
  arts_ifd.nr_terminals = 0;
  arts_ifd.nr_match_regexps = 0;
  arts_ifd.nr_skip_regexps = 0;
  arts_ifd.nr_syntax_nonterminals = 0;
  arts_ifd.nr_neg_memos = 0;
  arts_ifd.nr_choices = 0;
  arts_ifd.nr_positions = 0;
  arts_ifd.eos_terminal = 0;
  arts_ifd.lexicon_used = 0;

  /* Run time options */
  arts_ifd.neg_memo_option = 0;
  arts_ifd.pos_memo_option = 0;
  arts_ifd.directors_option = 0;
  arts_ifd.counters_option = 0;
  arts_ifd.profile_option = 0;
  arts_ifd.trace_option = 0;
  arts_ifd.label_bracket = 0;
  arts_ifd.no_output = 0;
  arts_ifd.transduce_option = 0;
  arts_ifd.generate_option = 0;
  arts_ifd.graph_option = 0;
  arts_ifd.verbose_option = 0;
  arts_ifd.segment_mode = 0;
  arts_ifd.alphabet_fname = "";			/* Default translation */
  arts_ifd.invisible_chars = NULL;
  arts_ifd.word_terminator_chars = NULL;

  /* Auxilary fields for lexer */
  arts_ifd.blanks = " \t\n\r";			/* Default blanks, currently not overruled */
  arts_ifd.translate_src = NULL;
  arts_ifd.translate_dst = NULL;

  /* Desirable runtime options */
  arts_ifd.hybrid_parsing_option = 0;
  arts_ifd.max_parses = INT_MAX;

  /* Command line options */
  arts_ifd.parsing_stats_option = 0;
  arts_ifd.research_stats_option = 0;
  arts_ifd.lexer_stats_option = 0;
  arts_ifd.total_stats_option = 0;
  arts_ifd.transduce_option = 0;
  arts_ifd.best_parsings_option = 0;
  arts_ifd.lcsdoc_sync_option = 0;
  arts_ifd.max_parsetime = INT_MAX;
  arts_ifd.max_edit_distance = 0;

  /* Interface to tables */
  arts_ifd.affix_domains = NULL;
  arts_ifd.affix_weights = NULL;
  arts_ifd.nont_domains = NULL;
  arts_ifd.term_memo_dir = NULL;
  arts_ifd.match_memo_dir = NULL;
  arts_ifd.skip_memo_dir = NULL;
  arts_ifd.lex_memo_dir = NULL;
  arts_ifd.memo_enable_table = NULL;
  arts_ifd.affix_names = NULL;
  arts_ifd.term_names = NULL;
  arts_ifd.nonterm_names = NULL;
  arts_ifd.match_regexp_names = NULL;
  arts_ifd.skip_regexp_names = NULL;
  arts_ifd.alternatives_profile_table = NULL;
};
