/*
   File: acoder.h
   Generates agfl object code in various segments

   CVS ID: "$Id: acoder.h,v 1.3 2006/12/01 09:12:41 marcs Exp $"
*/
#ifndef IncACoder
#define IncACoder
#include "lexer.h"
#include "opcode.h"

/* Define the available segments */
#define MAX_SEGS 6
typedef enum
	{ abs_segment, code_segment, interface_segment,
	  data_segment, rotext_segment, error_segment,
	} segment;

/* Define a structure for an operand and an instruction */
typedef struct operand_rec
	{ token tk;
	  segment seg;
	  int value;
	  char *svalue;
	} operand;

/* Define a structure for an opcode with its operands */
#define MAX_OPNDS 5
typedef struct instr_rec
	{ opcode opc;
	  int nr_opnds;
	  operand opnds[MAX_OPNDS];
	} instr;

/* Exported routines */
char *string_from_segment (segment seg);
void get_current_location (segment *ret_seg, int *ret_value);
void set_current_segment (segment seg);
void code_empty_instruction ();
void code_instruction (instr *ins);
void code_word (operand *opnd);
void code_string (operand *opnd);
void init_acoder ();
void finish_acoder ();

#endif /* ACoder */
