%{
// Scanner module for usage with the bison generated parser.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: scanner.l,v 1.18 2007/07/27 19:43:20 marcs Exp $

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <stdlib.h>

using namespace std;
#include <string.h>

#include "parserinterface.h"
#include "parser.h"

char* str_input_cpy(char* src, int len);
static int col_nr = 0;

#define YY_NO_UNPUT		1
#define YY_NEVER_INTERACTIVE	1

%}

%option yylineno
%option noyywrap

LAYOUT      [ \t\r\015\032]+
COMMENT     #.*
NUMBER      0|[1-9][0-9]*
DIGIT	    [0-9]
STR_CHARS   ((\\.)|[ !#-\[\]-~\177-\377])+
STRING      \"{STR_CHARS}\"
ORNAMENT    [$+\-?@^~_]
PLUSMINUS   [+-]
LETTER      [a-zA-Z\177-\377]
LETMENT	    ({LETTER}|{DIGIT}|{ORNAMENT})
IDPART      {PLUSMINUS}?{LETTER}{LETMENT}*


%%

\n              { col_nr = 1; return NEWLINE; }
{COMMENT}   	{ col_nr += yyleng; }
{LAYOUT}    	{ col_nr += yyleng; }
{NUMBER}    	{
                    col_nr += yyleng;
                    yylval.number = atoi(yytext);
                    return NUMBER;
                }
{STRING}        {
                    col_nr += yyleng;
                    yylval.chars = str_input_cpy(yytext, yyleng);
                    return STRING;
                }
{IDPART}	{
                    col_nr += yyleng;
                    yylval.string_ptr = new string(yytext);
                    return IDPART;
                }
,           	{ col_nr += yyleng; return COMMA; }
\(          	{ col_nr += yyleng; return OPENPAR; }
\)          	{ col_nr += yyleng; return CLOSEPAR; }
\|          	{ col_nr += yyleng; return VBAR; }
.           	{ col_nr += yyleng; return yytext[0]; }

%%

int get_line_nr()
{
    return yylineno;
}

int get_col_nr()
{
    return col_nr;
}

char* str_input_cpy(char* src, int len)
{
    char* dst;

    dst = strdup(src + 1);	/* skip opening quote */
    dst[len - 2] = '\0';	/* overwrite closing quote */

    return dst;
}

void reset_scanner_counters()
{
    yylineno = 1;
    col_nr = 1;
}

