/*
   File: nonterminals.h
   Maintains the administration of all nonterminals + their formal parameters

   Copyright 2007 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: nonterminals.h,v 1.5 2007/09/12 12:59:18 marcs Exp $"
*/
#ifndef IncNonterminals
#define IncNonterminals

/* libabase inclusion */
#include <abase_fileutil.h>

/* Local include */
#include "dyn_array.h"

/* Exported routines */
int lookup_nonterminal (char *nont_name, int arity);
int_array formals_from_nonterminal (int nont_index);
int register_new_nonterminal (char *nont_name, int nont_nr, int_array formals);
int register_new_call (int nont_id, int_array actuals);

/* Init, output and finish */
int nr_of_nonterminals ();
int nr_of_calls ();
void generate_nonterminals_info (FILE *info);
void dump_call (FILE *dump, int call_id);
void bin_save_nonterminals (BinFile bf);
void bin_save_calls (BinFile bf);
int has_new_lif_nonterminals (BinFile bf);
void init_nonterminals ();

#endif /* IncNonterminals */
