/*
   File: affix_values.h
   Maintains the administration of all affix values

   Copyright 2007 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: affix_values.h,v 1.9 2007/06/06 09:17:37 marcs Exp $"
*/
#ifndef IncAffixValue
#define IncAffixValue

/* libabase inclusion */
#include <abase_repr.h>
#include <abase_fileutil.h>

/*
   Introduce some simple (formal) typing
   Non negative types index the set affix table.
*/
#define FormalINT   (-1)
#define FormalTEXT  (-2)
#define FormalSET   (-3)
#define FormalUNION (-4)
#define FormalERROR (-5)

/* Registry and lookup of affixes */
int lookup_set_affix (char *affix_name);
int register_new_int_affix (int value);
int register_new_text_affix (char *value);
int register_new_set_affix (char *affix_name, int coder_number, Bitset32 affix_value,
			    int lhs, int prev_lhs);
int register_new_union_affix (int_array idxs, int formal);

/* Type checking affixes */
char *affix_name_from_index (int affix_index);
Bitset32 affix_value_from_index (int affix_index);
int affix_belongs_to_domain (int affix_index, int domain_index);
void calculate_affix_values_closure ();

/* Init, output and finish */
int nr_of_int_affixes ();
int nr_of_text_affixes ();
int nr_of_set_affixes ();
void generate_affix_values_info (FILE *info);
void dump_affix_value (FILE *dump, int fpar, int act);
void bin_save_affix_values (BinFile bf);
int has_new_lif_affix_values (BinFile bf);
void init_affix_values ();

#endif /* IncAffixValue */
