/*
   File: symbol_table.h
   Stores symbols with their value

   CVS ID: "$Id: symbol_table.h,v 1.3 2006/12/01 09:12:41 marcs Exp $"
*/
#ifndef IncSymbolTable
#define IncSymbolTable

/* local includes */
#include "acoder.h"

/* Introduce a symbol as an opaque type */
typedef struct symbol_rec *symbol;

/* Operations of the symbol table */
int enter_symbol (char *sy, symbol *entry);
int lookup_symbol (char *sy, symbol *entry);
void get_symbol_info (symbol sy, segment *segment, int *value);
void update_symbol_info (symbol sy, segment segment, int value);
void init_symbol_table ();
void dump_symbol_table ();
void ddump_symbol_table ();

#endif /* IncSymbolTable */
