/*
 * edit distance - calculate the edit distance between two strings
 *
 * Copyright 2005 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: edit_distance.h,v 1.4 2005/04/02 19:16:11 andres Exp $ 
 */

#ifndef edit_distance_h
#define edit_distance_h

#include <limits.h>

#ifdef DEBUG_ED
#   define DB_ED(x) x
#else
#   define DB_ED(x)
#endif

#ifndef edit_distance_c
typedef struct EDE EDE;
#endif

EDE * edit_distance_new_environment (const char *A, const char *B, const char *place);
EDE * edit_distance_renew_environment (EDE *h, const char *A, const char *B);
void  edit_distance_release_environment (EDE **h, const char *place);
int   edit_distance_get_limited_distance (EDE *h, int n);
char* edit_distance_get_path (EDE *h);

#define edit_distance_get_distance(h) edit_distance_get_limited_distance (h, INT_MAX)

#ifdef DEBUG_ED
void   edit_distance_debug_show_how (EDE *h);
#endif

#endif /* edit_distance_h */

