/*
   File: lexicon_input.h
   Defines interfacing definitions for the lexer I/O routines
   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lexicon_input.h,v 1.3 2006/09/27 16:01:31 marcs Exp $
*/
#ifndef IncLexiconInput
#define IncLexiconInput

#ifdef  __cplusplus
extern "C" {
#endif

typedef enum
{ SepRequired,
  SepDontCare
} SeparatorType;

/* Marks written by the coder to indicate the kind of terminal */
enum
{ EosMark		= '\0',
  EmptyMark		= '\0',
  PrefixMark		= '\1',
  SuffixMark		= '\2',
  InfixMark		= '\3',
  MultiTokenMark	= '\4',
  SpaceMark		= ' '
};

/* Lexeme classification */
typedef enum
{ Prefix,
  Infix,
  Suffix,
  MultiToken,
  SingleToken
} LexemeType;

unsigned char lxcn_get_lex_mark (LexemeType lex_type);

int lxcn_is_eos (unsigned char c);
int lxcn_is_space (unsigned char c);
int lxcn_is_blank (unsigned char c);
int lxcn_is_terminator (unsigned char c);
int lxcn_is_invisible (unsigned char c);
int lxcn_translate (unsigned char c);
int lxcn_check_terminator (SeparatorType sep_type, unsigned char c);
void lxcn_init_char_tables (char *blanks, char *terminators, char *invisibles, 
			    char *translate_src, char *translate_dst);

#ifdef  __cplusplus
}
#endif

#endif /* IncLexiconInput */
