/*
   File: lexicon.h
   Defines interfacing with the lexicon library

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lexicon.h,v 1.25 2006/09/27 16:01:31 marcs Exp $"
*/
#ifndef lexicon_h
#define lexicon_h

#include <stdio.h>
#include <sys/types.h>

/* libabase includes */
#include <abase_repr.h>

#ifdef DEBUG_LEX
#   define DB_LEX(x) x
#else
#   define DB_LEX(x)
#endif

#ifdef  __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------*/
typedef struct lexicon_rec *Lexicon;
typedef void   *Trie;

Trie	  lxcn_get_lexicon_trie (Lexicon lex);
void      lxcn_get_params_from_entry_in_list (Lexicon lex, int entry_list, int *nontnr, int *arity,
                              		      Penalty *penalty, TaggedValue **params);
int       lxcn_try_advance_to_next_entry_in_list (Lexicon lex, int *lst);
int       lxcn_find_lex_nonterminal_with_arity (Lexicon lex, char *nont_name, int arity);

Lexicon   lexicon_new (FILE* lex_file);
void      lexicon_free (Lexicon lex);

int       lexicon_get_nr_nonterminals (Lexicon lex);
char*     lexicon_get_nont_name (Lexicon lex, int nont_nr);
int       lexicon_get_nont_arity (Lexicon lex, int nont_nr);
char*     lexicon_get_nont_param_name (Lexicon lex, int nont_nr, int param_nr);
int       lexicon_get_nont_param_nr (Lexicon lex, int nont_nr, int param_nr);
int       lexicon_nont_exists (Lexicon lex, int nont_nr);

int       lexicon_get_nr_setaffixes (Lexicon lex);
char*     lexicon_get_setaffix_name (Lexicon lex, int aff_nr);
Bitset    lexicon_get_setaffix_bitset (Lexicon lex, int aff_nr);
int       lexicon_get_setaffix_nont_flag (Lexicon lex, int aff_nr);
int       lexicon_get_setaffix_nr_lhsses (Lexicon lex, int aff_nr);
char*     lexicon_get_setaffix_lhs_name (Lexicon lex, int aff_nr, int lhs_nr);
int       lexicon_affix_belongs_to_lhs (Lexicon lex, int aff_nr, int lhs_nr);

#ifdef  __cplusplus
}
#endif
#endif /* lexicon_h */
