/*
   File: abase_test.c
   Simple test program to check some of the functionality of the libabase

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_test.c,v 1.2 2005/12/07 12:39:46 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* local includes */
#include "abase_porting.h"
#include "abase_error.h"
#include "abase_dstring.h"
#include "abase_meminfo.h"

int main ()
	{ dstring my = abs_init_dstring (16);
	  char *result;
	  int ix;
	  for (ix = 1; ix <= 10; ix++)
	     abs_sprintfa_dstring (my, "%d x 42 = %d\n", ix, ix * 42);
	  result = abs_finish_dstring (my);
	  abs_message (result);
	  abs_report_meminfo ();
	  abs_bug ("abase_test", "none of the %d bugs found", 43);
	};

