/*
   File: abase_porting.h
   Defines macros to generate code compilable for WIN32, MINGW and GNU

   CVS ID: "$Id: abase_porting.h,v 1.4 2006/06/28 08:53:11 marcs Exp $"
*/
#ifndef IncAbasePorting
#define IncAbasePorting

/*
   Include generated config.h if we have it
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
   Define the 64 bit ints and constants
*/
#if defined(WIN32) && !defined(MINGW)

/* WIN32 with Visual C++ */
typedef int int32;
typedef unsigned int u_int32;
typedef __int64 int64;
typedef unsigned __int64 u_int64;

#define u_int64_const(x) (x##ui64)
#define int64_const(x) (x##i64)
#include <windows.h>
#include <io.h>

/* Define maximum path length */
#define MAXPATHLEN 255

/* Define strcasecmp (BSD 4.4) in other terms */
#define strcasecmp(a,b) stricmp(a,b)

#else
/* MINGW with gcc */
/* Unix with gcc */
#include <sys/types.h>
#include <sys/param.h>
#include <unistd.h>

typedef int int32;
typedef unsigned int u_int32;
typedef unsigned long long int u_int64;
typedef long long int int64;

#define u_int64_const(x) (x##ULL)
#define int64_const(x) (x##LL)

#ifdef MINGW
#include <windows.h>
#endif /* NoMINGW */
#endif /* WIN32 && !MINGW */

/* Define the maximum string length */
#define MAXSTRLEN 65536

#endif /* IncAbasePorting */
