/*
   File: abase_mm_alloc.h
   Defines managed memory allocation routines

   Copyright 2006 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_mm_alloc.h,v 1.1 2006/03/01 16:20:04 marcs Exp $"
*/
#ifndef IncAbaseMmAlloc
#define IncAbaseMmAlloc

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>

/* General allocation routines */
void abs_mm_init ();
void *abs_mm_malloc (const size_t size, const char *place);
void *abs_mm_calloc (const size_t nr, const size_t size, const char *place);
char *abs_mm_new_string (const char *old, const char *place);
char *abs_mm_new_fmtd_string (const char *place, const char *format, ...);
void abs_mm_free (const char *place);

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseMmAalloc */
