/*
   File: abase_memalloc.h
   Defines general memory allocation routines

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_memalloc.h,v 1.8 2006/03/01 16:20:03 marcs Exp $"
*/
#ifndef IncAbaseMemalloc
#define IncAbaseMemalloc

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>

/* General allocation routines */
void *abs_malloc (const size_t size, const char *place);
void *abs_calloc (const size_t nr, const size_t size, const char *place);
void *abs_realloc (void *ptr, const size_t size, const char *place);
char *abs_new_string (const char *old, const char *place);
char *abs_new_fmtd_string (const char *place, const char *format, ...);
void abs_free (void *ptr, const char *place);

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseMemalloc */
