/*
   File: abase_fileutil.h
   Defines routines to handle files and filenames, and save and load
   binary data (lexica, compiled grammars, etc. ) in a machine and
   OS independent way.

   The format of the binary IO is taken from the ELF standard for the
   primitive types char, int and string. Furthermore we assume that
   structured data is saved recursively, field by field. Binary files
   contain an AGFL specific header, version and checksum.

   CVS ID: "$Id: abase_fileutil.h,v 1.1 2006/07/22 20:36:11 marcs Exp $"
*/
#ifndef IncAbaseFileutil
#define IncAbaseFileutil

#ifdef __cplusplus
extern "C" {
#endif

/* General routines for all kind of files */
int abs_file_exists (char *path);
int abs_is_normal_file (char *path);
int abs_is_directory (char *path);

/* Filename construction */
char *construct_path (char *directory, char *fname);

/* Type definition and initialisation for binary files */
typedef struct bin_file_rec *BinFile;
BinFile abs_bin_fopen (char *path, char *mode);
void abs_bin_fclose (BinFile bf);
int abs_file_exists (char *path);

/* Binary saving routines */
void abs_bin_save_eof     (BinFile bf);
void abs_bin_save_char    (BinFile bf, char x);
void abs_bin_save_int     (BinFile bf, int x);
void abs_bin_save_string  (BinFile bf, char *x);
void abs_bin_save_version (BinFile bf, char *kind);

/* Binary loading routines */
void abs_bin_verify_eof      (BinFile bf);
void abs_bin_load_char       (BinFile bf, char *x);
void abs_bin_load_int        (BinFile bf, int *x);
void abs_bin_load_string     (BinFile bf, char **x);
void abs_bin_verify_version  (BinFile bf, char *kind);

#ifdef __cplusplus
}
#endif

#endif /* IncAbaseFileutil */
