// Class definition for the lexicon entry list, stored in the .blf file.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexentrylist.h,v 1.11 2006/03/15 11:58:22 marcs Exp $

#ifndef LEXENTRYLIST_H
#define LEXENTRYLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <vector>
#include <map>
#include <iostream>
#include "entry.h"
#include "lexnontermlist.h"

typedef vector<unsigned> LenArray;

typedef struct
{
    long nont_idx;
    Penalty penalty;
    LenArray par_list;
} LexEntryEl;

typedef pair<Entry,unsigned> entry_idx_pair_t;
typedef map<string,entry_idx_pair_t> entries_t;
typedef vector<entries_t::iterator> entries_index_t;

class LexEntryList
{
    private:
        entries_t entries;
        entries_index_t entries_index;

        vector<LexEntryEl> entrytable;
        //Entry search_index(unsigned idx) const;
        LenArray generate_param_indexes(Entry e) const;
        inline entries_t::const_iterator
	    get_from_entries_by_idx(unsigned idx) const
		{ return entries_index[idx]; }


    public:
        int get_index(Entry &e) const;
        void add_entry(Entry& e);
        void add_entrylist(EntryList &l);

        void generate_table(class LexNontermList *lex_nonterm_List); //nonconst
        void dump(void) const;
	void write_output(ostream& os) const; // to lexicon
        inline unsigned size(void) const
		{ return entrytable.size(); }
        inline LexEntryEl search_lexentryel_by_index(unsigned idx) const
        	{ return entrytable[idx]; }
};

inline int
LexEntryList::get_index(Entry &e) const
{
    entries_t::const_iterator i = entries.find(e.to_string());
    if (i != entries.end()) {
        return i->second.second;
    } else {
        return -1;
    }
}

inline void
LexEntryList::add_entry(Entry& e)
{
    int index = get_index(e);
    
    if (index == -1) {
        index = entries.size();
#if 0
        entries_index.push_back(entries.insert(entries.begin(),
                                make_pair(e.to_string(),
                                          entry_idx_pair_t(e, index))));
#else
	string etos = e.to_string();
        entries_index.push_back(entries.insert(entries.begin(),
                                make_pair(etos,
                                          entry_idx_pair_t(e, index))));
#endif
    }
}

inline void
LexEntryList::add_entrylist(EntryList &l)
{
    for (unsigned i = 0; i < l.size(); ++i) {
        add_entry(l[i]);
    }
}

#endif // LEXENTRYLIST_H
