/*
   File: rtsopt.h
   RTS option routine definitions.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: rtsopt.h,v 1.24 2006/10/18 12:03:25 marcs Exp $"
*/
#ifndef rtsopt_h
#define rtsopt_h

/* exported options */
extern int parsing_stats_option;
extern int lexer_stats_option;
extern int total_stats_option;
extern int show_options_option;
extern int show_penalties_option;
extern int show_timebreak_option;
extern int best_parsings;
extern int io_sync_option;
extern int hybrid_parsing_option;
extern int count_option;
extern int text_tracing_option;

/* exported string access routines */
char *get_parser_name (void);
char *get_input_file_name (void);
char *get_output_file_name (void);
char *get_alphabet_file_name (void);
char *get_input_pos_fname (void);

/* exported bounds */
extern int max_parses;
extern int max_parsetime;

/* exported interface */
void process_options (int argc, char* argv[]);
void show_options ();

#endif /* rtsopt_h */
