/*
   File: symbol_table.h
   Stores symbols with their value

   CVS ID: "$Id: symbol_table.h,v 1.1 2006/10/11 13:41:07 marcs Exp $"
*/
#ifndef IncSymbolTable
#define IncSymbolTable

/* Introduce a symbol as an opaque type */
typedef struct symbol_rec *symbol;

/* Operations of the symbol table */
int enter_symbol (char *sy, symbol *entry);
int lookup_symbol (char *sy, symbol *entry);
void get_symbol_info (symbol sy, int *segment, int *value);
void update_symbol_info (symbol sy, int segment, int value);
void init_symbol_table ();
void dump_symbol_table ();

#endif /* IncSymbolTable */
