/*
   File: parser.h
   Defines the parser of Agfl assembler
  
   Copyright 2006 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: parser.c,v 1.2 2006/10/18 15:45:39 marcs Exp $"
*/

/* System includes */
#include <stdio.h>
#include <string.h>

/* Libabase includes */
#include <abase_error.h>

/* Local includes */
#include <options.h>
#include <lexer.h>
#include <parser.h>

/* Exported variables */
int pass_two;

/* Try open input */
static FILE *try_open_source (char *fname)
	{ FILE *fd = fopen (fname, "r");
	  if (fd == NULL)
	    abs_fatal ("could not open input file '%s'", fname);
	  return (fd);
	}

/* Exported code */
void prepare_pass_one ()
	{ FILE *fd = try_open_source (assembler_fname);
	  init_lexer (fd, assembler_fname);
	  pass_two = 0;
	}

void parse_input ()
	{ while (curr_token != EOFSYMBOL)
	    { dump_token ();
	      read_token ();
	    };
	}

void prepare_pass_two ()
	{ pass_two = 1;
	  reinit_lexer ();
	}
