/*
   File: lexer.h
   Does lexical analysis of Agfl assembler
  
   Copyright 2006 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lexer.h,v 1.3 2006/10/18 15:45:39 marcs Exp $"
*/
#ifndef IncLexer
#define IncLexer

/* Define the tokens, to begin with undefined */
typedef enum { UNDEFINED,

/* General categories */
SYMBOL, NUMBER, SIGNED_NUMBER, STRING,

/* Punctuation marks */
COLON, COMMA, POINT,
LEFTPARENTHESIS, RIGHTPARENTHESIS,
EOLN,

/* End of file */
EOFSYMBOL } token;

/* Exported lexer variables */
extern token curr_token;
extern int curr_line;
extern int curr_column;
extern char *curr_sval;
extern unsigned curr_uval;
extern int curr_nval;

/* Error count */
extern int lexer_errors;

/* Exported code */
void init_lexer (FILE *fd, char *fname);
void reinit_lexer ();
void read_token ();
void dump_token ();

#endif /* IncLexer */
