/* Interfacing definitions for the lexicon search library routines.
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: lexicon_search.h,v 1.8 2005/04/05 13:30:19 andres Exp $ */

#ifndef lexicon_search_h
#define lexicon_search_h

#include <lexicon.h>
#include <abase_lex_input.h>

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef lexicon_search_c
typedef struct lxcn_TrieData lxcn_TrieData;
#endif

extern int max_edit_distance;

const unsigned char* lxcn_approx_match_trie(const lxcn_Trie* trie, lxcn_TrieData* data);
lxcn_TrieData* lxcn_init_approx_match_trie(const unsigned char* input, abs_LexemeType lex_type, abs_SeparatorType sep_type);
void lxcn_exit_approx_match_trie (lxcn_TrieData *trie_data);

unsigned char * lxcn_get_lex_begin (lxcn_TrieData *trie_data);
unsigned char * lxcn_get_lex_end (lxcn_TrieData *trie_data);
long lxcn_get_info (lxcn_TrieData *trie_data);

#ifdef  __cplusplus
}
#endif

#endif /* lexicon_search_h */
