/*
   File: abase_error.h
   Defines routines for diagnostic messages

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_error.h,v 1.5 2005/04/21 14:09:40 andres Exp $"
*/
#ifndef IncAbaseError
#define IncAbaseError

#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Exported error logging code */
#define MAX_FMT_LEN 4096
void abs_exit (int error);
void abs_fatal (char *format, ...);
void abs_abort (char *location, char *format, ...);
void abs_bug (char *location, char *format, ...);
void abs_error (char *format, ...);
void abs_warning (char *format, ...);
void abs_message (char *format, ...);
void abs_printf (char *format, ...);
void abs_vprintf (char *format, va_list ap); 

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseError */
