/*
   File: abase_error.c
   Defines routines for diagnostic messages

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_error.c,v 1.4 2005/04/21 14:09:40 andres Exp $"
*/

/* standard includes */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

/* local includes */
#include "abase_error.h"

/* Various modes of failure */
void abs_exit (int error)
	{ exit (error);
	};

void abs_fatal (char *format, ...)
	{ char buf[MAX_FMT_LEN];
	  va_list argp;

	  va_start (argp, format);
	  vsprintf (buf, format, argp);
	  va_end (argp);

	  fprintf (stderr, "Fatal error: %s\n", buf);
	  abs_exit (1);
	};

void abs_abort (char *location, char *format, ...)
	{ char buf[MAX_FMT_LEN];
	  va_list argp;

	  va_start (argp, format);
	  vsprintf (buf, format, argp);
	  va_end (argp);

	  fprintf (stderr, "Abort (%s): %s\n", location, buf);
	  abs_exit (1);
	};

void abs_bug (char *location, char *format, ...)
	{ char buf[MAX_FMT_LEN];
	  va_list argp;

	  va_start (argp, format);
	  vsprintf (buf, format, argp);
	  va_end (argp);

	  fprintf (stderr, "Bug (%s): %s\n", location, buf);
	  fprintf (stderr, "Please contact agfl@cs.ru.nl\n");
	  abs_exit (1);
	};

void abs_error (char *format, ...)
	{ char buf[MAX_FMT_LEN];
	  va_list argp;

	  va_start (argp, format);
	  vsprintf (buf, format, argp);
	  va_end (argp);

	  fprintf (stderr, "Error: %s\n", buf);
	};

void abs_warning (char *format, ...)
	{ char buf[MAX_FMT_LEN];
	  va_list argp;

	  va_start (argp, format);
	  vsprintf (buf, format, argp);
	  va_end (argp);

	  fprintf (stderr, "Warning: %s\n", buf);
	};

void abs_message (char *format, ...)
	{ char buf[MAX_FMT_LEN];
	  va_list argp;

	  va_start (argp, format);
	  vsprintf (buf, format, argp);
	  va_end (argp);
	  fprintf (stderr, "%s\n", buf);
	};

void abs_printf (char *format, ...)
	{ char buf[MAX_FMT_LEN];
	  va_list argp;

	  va_start (argp, format);
	  vsprintf (buf, format, argp);
	  va_end (argp);
	  fprintf (stderr, "%s", buf);
	};

void abs_vprintf (char *format, va_list ap) 
	{ char buf[MAX_FMT_LEN];

	  vsprintf (buf, format, ap);
	  fprintf (stderr, "%s", buf);
	};
