// Key handling for AvlTrie class
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: key.h,v 1.5 2002/09/26 15:06:18 murphy Exp $

#ifndef KEY_H
#define KEY_H

#include <sys/types.h>

typedef	unsigned char KeyType;

inline int
compare(KeyType x, KeyType y)
{
    return x - y;
}

inline KeyType
head(const char* str)
{
    return (KeyType)*str;
}

inline int
has_tail(KeyType key)
{
    return (int)key;
}

inline const char*
tail(const char* str)
{
    if (*str) {
        return str + 1;
    } else {
        return 0;
    }
}

inline char*
text(unsigned key)
{
    static KeyType   buf[2];

    buf[0] = key;
    buf[1] = 0;
    return (char*)buf;
}

#endif
