/*
   File: util.h
   Specifies utility functions for agflcoder
  
   Copyright 2005, Radboud university of Nijmegen.
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: $Id: util.h,v 1.8 2005/09/06 10:03:16 marcs Exp $
*/
#ifndef IncUtil
#define IncUtil

/* Include CDL3 types */
#include <cdl3rts.h>

/* Support routines called from CDL3 */
char* wordform_cpy (char *wf, int line_nr);

/* FUNCTION copy word form (>TEXT1, >INT, TEXT2>) */
void E218_copy_word_form_TEXT_INT_TEXT (value v_TEXT1, value v_INT, value* v_TEXT2);

/* FUNCTION watch (INT>) */
void E216_watch_INT (value *v_INT);

/* FUNCTION get config version (TEXT>) */
void E300_get_config_version_TEXT (value* cdl_txt);

/* ACTION show memory usage */
void E301_show_memory_usage ();

#endif /* IncUtil */
