/* String utility function definitions.
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: str_util.h,v 1.4 2001/10/17 10:39:31 ejv Exp $ */

#ifndef str_util_h
#define str_util_h

#ifdef  __cplusplus
extern "C" {
#endif

extern const char PrefixMark;
extern const char SuffixMark;
extern const char InfixMark;
extern const char MultiTokenMark;

char* lexeme_copy(char* dst, char* src, int len);
char* strip_copy(char* dst, char* src);

int is_affix_nonterminal_part(char* txt);
int is_affix_terminal_part(char* txt);
int is_syntax_nonterminal_part(char* txt);
int is_syntax_nonterminal_id(char* txt);
int is_module_name_part(char* txt);

#ifdef  __cplusplus
}
#endif

#endif /* str_util_h */
