// Options class is used for (commandline) option parsing.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: options.h,v 1.9 2002/11/07 00:44:02 murphy Exp $

#ifndef OPTIONS_H
#define OPTIONS_H

#include <sys/types.h>
#include <string>

class Options
{
    private:
        bool force_compile;
        bool verbose_option;
        bool log_sizes_option;
        bool log_with_timestamp_option;
        string outfile;
        string lex_interface_file;

        void show_synopsis();
        void show_help();
        void say_hello();
        void show_version();

    public:
        Options(int argc, char* const argv[]);

	inline bool force_compilation() const
		{ return force_compile; }
	inline bool verbose() const
		{ return verbose_option; }
	inline bool log_sizes() const
		{ return log_sizes_option; }
	inline bool log_with_timestamp() const
		{ return log_with_timestamp_option; }
	inline string get_output_filename() const
		{ return outfile; }
	inline string get_lifname() const
		{ return lex_interface_file; }
};

extern Options * options;

#endif // OPTIONS_H
