// LexEntryList class implementation
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexentrylist.cc,v 1.8 2003/11/26 22:15:14 pspiertz Exp $

using namespace std;
#include <stdlib.h>
#include <iostream>
#include "globals.h"
#include "lexfileio.h"
#include "lexentrylist.h"
#include "globlexafflists.h"
#include "lexnontermlist.h"

void
LexEntryList::dump(void) const
{
    cout << "---- LexEntryList::dump" << endl;

    for (unsigned i = 0; i < entrytable.size(); ++i) {
        LexEntryEl el = entrytable[i];

        cout << "\t" << i;
        cout << " ->";
        cout << "\tnonterm_list index " << el.nont_idx << endl;
        cout << "\t\tfrequency: " << el.penalty << endl;

        cout << "\t\taffix indices:";
        for (unsigned j = 0; j < el.par_list.size(); ++j) {
            cout << " " << el.par_list[j];
        }
        cout << "." << endl;
    }

    cout << "----" << endl;
}

LenArray
LexEntryList::generate_param_indexes(Entry e) const
{
    LenArray pars;
    pParam p = e.nonterm->params;

    while (p) {
        Param par = p->elem;
        switch(par.type) {
            case IdType:
                pars.push_back(lex_affixname_list.get_index(par.value.id));
                break;
            case SetType: {
                    string set_str(convert_to_string(par.value.set));
                    pars.push_back(lex_affixname_list.get_index_of_set(set_str));
                    break;
                }
            case IntType:
                pars.push_back(lex_intaffix_list.get_index(par.value.number));
                break;
            case TextType:
                pars.push_back(lex_textaffix_list.get_index(par.value.id));
                break;
            case AnyText:
            case AnyInt:
                break;
            default:
                cerr << "internal error in LexEntryList::generate_param_indexes: unknown paramtype" << endl;
                exit(1);
        }

        p = p->next;
    }

    return pars;
}

void
LexEntryList::generate_table(class LexNontermList *lex_nonterm_List) //nonconst
{
    for (unsigned i = 0; i < entries.size(); ++i) {
        LexEntryEl el;
        Entry e = get_from_entries_by_idx(i)->second.first;

        el.nont_idx = lex_nonterm_List->get_index(e);
        el.penalty = e.freqpen.penalty;

        el.par_list = generate_param_indexes(e);

        entrytable.push_back(el);
    }
}

void
LexEntryList::write_output(ostream& os) const
{
    write_lex_size_and_log(os, size(), " entries to file");

    for (unsigned idx = 0; idx < size(); ++idx) {
        LexEntryEl el = search_lexentryel_by_index(idx);

        write_lex_index(os, el.nont_idx);
        write_lex_set(os, el.penalty);
        
        for (unsigned i = 0; i < el.par_list.size(); ++i) {
            write_lex_index(os, el.par_list[i]);
        }
    }
}
