// Class for encapsulation of formatted writes in tables.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: field.h,v 1.5 2003/11/26 22:15:13 pspiertz Exp $

#ifndef FIELD_H
#define FIELD_H

#include <iostream>

//------------------------------------------------------------------------------
// class Field
//
// Description:
//	Encapsulates formatted write of field in tabular.
//------------------------------------------------------------------------------

class Field
{
    public:
        Field(const char*, unsigned = 15);
        Field(const double&, unsigned = 15);
        Field(const unsigned&, unsigned = 15);
        void print(ostream&) const;

    private:
        typedef enum
        {
            String_t,
            Float_t,
            Num_t
        } Type;

        union
        {
            const char*	str;
            double	float_val;
            unsigned	num_val;
        };

        Type type;
        unsigned width;
};

inline ostream&
operator <<(ostream& os, const Field& field)
{
    field.print(os);
    return os;
}

#endif // FIELD_H
