/* RTS option treatment
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: rtsopt.c,v 1.35 2003/08/12 19:30:09 pspiertz Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <time.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else /* HAVE_GETOPT_H */
#ifdef HAVE_GETOPT
#include <unistd.h>
#endif /* HAVE_GETOPT */
#endif /* HAVE_GETOPT_H */
#include "rtscode.h"
#include "rtsio.h"
#include "rtsopt.h"

/*
 *------------------------------------------------------------------------------
 * Private data. Oh well, not so private as you think.
 *------------------------------------------------------------------------------
 */

static const char *parser_name = NULL;
static const char *input_file_name = NULL;
static const char *output_file_name = NULL;
gboolean parsing_stats_option = FALSE;
gboolean lexer_stats_option = FALSE;
gboolean total_stats_option = FALSE;
gboolean show_options_option = FALSE;
gboolean show_penalties_option = FALSE;
gboolean show_timebreak_option = FALSE;
gboolean text_tracing_option = FALSE;
gboolean best_parsings = FALSE;
gboolean io_sync_option = FALSE;
gboolean hybrid_parsing_option = FALSE;
gboolean count_option = FALSE;     /* 2002-04-02  PB  count AGFL opcodes and rules */

int lexing_method = WORD_LEXING;
int lex_out_format = G_OUT_FORMAT_STANDARD;

static void
set_max_number_of_parses(int v)
{
    if (v < 0) {
	max_parses = 0;
    } else {
	max_parses = v;
    }
}

static void
set_max_parse_time(long v)
{
    if (v < 0) {
	max_parsetime = 0;
    } else {
	max_parsetime = v;
    }
}

/*
 *------------------------------------------------------------------------------
 * Public
 *------------------------------------------------------------------------------
 */

void
store_parser_name(char* name)
{
#ifdef WIN32
    int len;

    len = strlen(name);
    if (len > 4 && strcasecmp(name + len - 4, ".exe") == 0) {
	name[len - 4] = '\0';
    }
#endif

    parser_name = name;
}

const char*
get_parser_name()
{
    return parser_name;
}

void
store_input_file_name(const char* name)
{
    input_file_name = name;
}

const char*
get_input_file_name()
{
    return input_file_name;
}

static void
store_output_file_name(const char* name)
{
    output_file_name = name;
}

const char*
get_output_file_name()
{
    return output_file_name;
}


#define	NL	"<NL>"
#define	CR	"<CR>"
#define	TAB	"<TAB>"

static void
print_quoted(char *buf, unsigned char const * s)
{
    char c;
    char *p = buf;

    while ((c = *s++)) {
        switch (c) {
            case '\n':
                sprintf(p, NL);
                p += strlen(NL);
                break;
            case '\015':
                sprintf(p, CR);
                p += strlen(CR);
                break;
            case '\t':
                sprintf(p, TAB);
                p += strlen(TAB);
                break;
            default:
                *p++ = c;
                break;
        }
    }

    *p = '\0';
}

static const char*
convert_time_to_text(long time)
{
    time_t clock = (time_t)time;
    char *txt_time = ctime(&clock);
    txt_time[24] = '\0';
    return txt_time;
}

void
show_options()
{
    printf("Grammar last changed on %s\n"
           "Parser generated using AGFL Gen version %s\n",
           convert_time_to_text(gra_version), agfl_version);

    if (client_option) {
        printf("Operating in client mode\n");
    }

    if (word_terminator_chars != NULL) {
        char buf[256];

        print_quoted(buf, word_terminator_chars);
        printf("Word terminators are '%s'\n", buf);
    }

    if (invisible_chars != NULL) {
        char buf[256];

        print_quoted(buf, invisible_chars);
        printf("Invisible characters are '%s'\n", buf);
    }

    if (graph_option) {
        printf("Displaying lexical graph\n");
    }

    if(directors_option) {
        printf("Directors available\n");
    }

    if(pos_memo_option) {
        printf("Positive memoization available\n");
    }

    if(neg_memo_option) {
        printf("Negative memoization available\n");
    }

    if (max_parses < LONG_MAX) {
        printf("Maximum number of parses is %ld\n", max_parses);
    }

#if 0
    if (left_recursion) {
        printf("Grammar is leftrecursive\n");
    }
#endif

    if (max_parsetime < LONG_MAX) {
        printf("Maximum parse time is %ld seconds\n", max_parsetime);
    }

    if (label_bracket && !no_output) {
        printf("Labelled bracket output\n");
    }

    if (no_output) {
        printf("Suppressing output\n");
    } else if (transduce_option && !no_output) {
        printf("Transducing\n");
    }

    if (counters_option) {
        printf("Showing counters\n");
    }

    if (generate_option) {
        printf("This is a sentence generator\n");
    }

    if (hybrid_parsing_option) {
        printf("Hybrid parsing enabled\n");
    }
}

/*
** -h shows options
*/

static void
show_version()
{
    printf("This parser was generated with %s version %s at %s\n", PACKAGE,
           VERSION, convert_time_to_text(gra_version));
}

static void
show_help()
{
    /* 2002-04-02  PB  counting option added */
    show_version();
    /* FIXME: the -A option seems deprecated */
    rtsMessage(
        "OPTION      DEFAULT     PURPOSE\n"
        "-P number   infinite    maximum number of parses\n"
        "-T number   infinite    maximum total parse time (in seconds)\n"
        "-B          off         search parsings for best penalty level\n"
        "-b          off         labelled bracket output\n"
        "-H          off         enables hybrid parsing\n"
        "-O          off         suppress output\n"
        "-o file     stdout      write output to file\n"
        "-t          off         transduce (or tree)\n"
        "-A file     off         use alphabet file\n"
        "-G          off         show lexical graph\n"
        "-V                      show version\n"
        "-S          off         enable I/O synchronisation\n"
        "-v          off         set verbosity. possible values:\n"
        "            options     show parser options\n"
        "            lexer       show all lexer output\n"
        "            parser      show all parser output (ie. penalties)\n"
        "            totals      show totals (ie. time)\n"
        "            all         all previous four\n"
        "            timebreak   show when the timeout kicks in\n"
        "            penalties   show penalties in the parsings\n"
        "-c          off         count opcodes and rule calls\n"
        "-h          off         show this help\n");
}

void
check_for_verbose_options(char *opt_arg, int *errflg)
{
    if (opt_arg == NULL) {
        printf("Not specified what to print with -v, so assuming parsing, lexer, options, and totals.\n");
        parsing_stats_option = TRUE;
        lexer_stats_option = TRUE;
        total_stats_option = TRUE;
        show_options_option = TRUE;
        return;
    }

    if (!strcasecmp(opt_arg, "all")) {
        parsing_stats_option = TRUE;
        lexer_stats_option = TRUE;
        total_stats_option = TRUE;
        show_options_option = TRUE;
        return;
    }
    
    if (!strcasecmp(opt_arg, "parser")) {
        parsing_stats_option = TRUE;
        return;
    }

    if (!strcasecmp(opt_arg, "lexer")) {
        lexer_stats_option = TRUE;
        return;
    }

    if (!strcasecmp(opt_arg, "totals")) {
        total_stats_option = TRUE;
        return;
    }

    if (!strcasecmp(opt_arg, "options")) {
        show_options_option = TRUE;
        return;
    }
    
    if (!strcasecmp(opt_arg, "timebreak")) {
        show_timebreak_option = TRUE;
        return;
    }

    if (!strcasecmp(opt_arg, "penalties")) {
        show_penalties_option = TRUE;
        return;
    }

    (*errflg)++;
}

void
process_options(int argc, char* const argv[])
{
    char c;
    int errflg = 0;
#ifdef PROFILING
    #error "enter opt_str"
    char* opt_str = "";
#else
    char* opt_str = "Bbs:ci::w::GP:T:OA:o:m:thVv:SHk";
#endif

    store_parser_name((char*)argv[0]);

    while ((c = getopt(argc, argv, opt_str)) != EOF) {
        switch (c) {
            case 'v':
                check_for_verbose_options(optarg, &errflg);
                break;
            case 'b':
                label_bracket = TRUE;
                break;
            case 'c':                 /* 2002-04-02  PB  counting option added */
                count_option = TRUE;  /* 2002-04-02  PB  counting option added */
                break;                /* 2002-04-02  PB  counting option added */
            case 'w':
    /*            set_word_terminator_chars((unsigned char const *) optarg); */
                printf("depricated option: -w\nThis modifies the behaviour of the grammar far too much to make it a parser\noption. Please use the pragmat in the grammar file.\n");
                errflg++;
                break;
            case 'i':
                printf("depricated option: -i\nThis modifies the behaviour of the grammar far too much to make it a parser\noption. Please use the pragmat in the grammar file.\n");
                errflg++;
                break;
            case 'G':
                graph_option = TRUE;
                break;
            case 'P':
                set_max_number_of_parses(atoi(optarg));
                break;
            case 'T':
                set_max_parse_time(strtol(optarg, NULL, 10));
                break;
            case 'B':
                best_parsings = TRUE;
                break;
            case 'H':
                hybrid_parsing_option = TRUE;
                break;
            case 'O':
                no_output = 1;
                break;
            case 'o':
                store_output_file_name(optarg);
                break;
            case 'm':
                if (!strchr("wptG", optarg[0]) || optarg[1]) {
                    /* see rtscode.h for values */
                    printf("invalid lexing method -m: %s\n", optarg);
                    errflg++;
                } else if (optarg[0] == 'G') {
                    graph_option = TRUE;
                    lex_out_format = G_OUT_FORMAT_TRELLIS_INPUT;
                } else {
                    lexing_method = optarg[0];
                }
                break;
            case 'S':
                io_sync_option = TRUE;
                break;
            case 't':
                transduce_option = !transduce_option;
                break;
            case 'V':
                show_version();
                exit(0);
                break;
            case '?':
                errflg++;
                break;
            case 'h':
                errflg++;
                break;
            /* testing option: */
            case 'k':
                text_tracing_option = 1;
                break;
            default:
                rtsFatal("unknown option '-%c', use '%s -h' for help",
                        c, get_parser_name());
        }
    }

    if (errflg) {
        show_help();
        rtsExit(0);
    }
}

