@echo off

REM =====================================================================================
REM  setagfl.bat : script to run prior to using the AGFL system, in order to ensure
REM                setting of environment variables and search paths
REM  2003-01-28, PB

REM -------------------------------------------------------------------------------------
REM  definition of the "top" level of the agfl subdirectories.
REM  when the AGFL-files are not located in c:\agfl_2.2,
REM  the variable "GENBASE" should be changed to reflect the actual location.
REM 
REM  I.e., if the actual subdirectory is
REM      D:\INFORMATION_RETRIEVAL\LINGUISTIC_COMPONENT\AGFL_2.2
REM  the GENBASE environment variable should be defined as:
REM      SET GENBASE=D:\INFORMATION_RETRIEVAL\LINGUISTIC_COMPONENT\AGFL_2.2

SET GENBASE=c:\agfl_2.2

REM -------------------------------------------------------------------------------------
REM  location of C-compiler

SET GENCC=%GENBASE%\bin\gcc

REM -------------------------------------------------------------------------------------
REM  definition of assembler-command

SET GENAS=gcc -c -x assembler-with-cpp -

REM -------------------------------------------------------------------------------------
REM  location of AGFL libraries

SET LIBRARY_PATH=%GENBASE%\lib

REM -------------------------------------------------------------------------------------
REM  necessary extensions to search path settings

Path=%GENBASE%\bin;%path%

REM -------------------------------------------------------------------------------------
REM  location of AGFL alphabet translation file.
REM 
REM  if the environment variable AGFL_ALPHABET is not defined,
REM  all 8-bit characters are processed as-is,
REM  except for latin capitals in the lexicon (A...Z),
REM  which are by default translated to lowercase.
REM 
REM  To activate user-definable character translation, remove the comment-symbol from
REM  the line defining AGFL_ALPHABET below, and adapt the file (or a copy of the file,
REM  possibly located elsewhere and with a totally different name) as required.
REM 
REM  See file agfl_alphabet_docu.txt in subdirectory "alphabet" for the layout of the alphabet file.

REM SET AGFL_ALPHABET=%GENBASE%\alphabet\agfl_alphabet.txt
