      integer function getinp()
      implicit double precision (a-h,o-z)
      logical extest

      extest = .false.
      inquire(file="docker.inp",exist=extest)

      if (extest) then
        getinp = 1
      else
        getinp = 0
      endif

      return
      end

      program docker
      implicit double precision (a-h,o-z)
c
c     ##  COPYRIGHT (C) 2022 by G. Schaftenaar  ##
c
c     Docker Program
c     By G. Schaftenaar
c     Theochem, University of Nijmegen, The Netherlands
c     2022

      parameter (numat1=20000)
      parameter (mxcon=10)
      parameter (numatm=2000)
      parameter (mxres=42)
      parameter (mxel=100)
      parameter (mxsym=103)
      parameter (mxhsym=64)
      parameter (mxmol2=41)
      parameter (mxamb=1590)
      parameter (mxambc=49)
      parameter (mxgff=72)
      parameter (mexcl=10)
      parameter (mxrsa=23)
      parameter (mxata=9)
      parameter (mxatha=9)
      parameter (mxrsn=19)
      parameter (mxnucl=39)
      parameter (mxhnuc=27)
      parameter (mxrss=20)
      parameter (mxrso=24)
      parameter (mxato=10)
      parameter (mxatho=11)
      parameter (mxmmul=100)

      common /moldat/ natoms, norbs, nelecs,nat(numatm)
      common /atcom/ coo(3,numat1),rzp(numat1),ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1),
     &               icont(numat1)
      common /athlp/ iatoms, mxnat
      integer nsol
      common /types/ iff
      common /typbck/ ityp(numat1),ipdbt(numat1)
      integer amboff,ntca,ctca
      common /ambtyp/ amboff(mxrss*3),ntca(mxrss),ctca(mxrss),
     &                ncca(mxrsa),icca(2,mxata,mxrsa),
     &                nhha(mxrsa),ihha(2,mxatha,mxrsa),
     &                ncco(mxrso),icco(2,mxato,mxrso),
     &                nhho(mxrso),ihho(2,mxatho,mxrso),
     &                nnuc(mxrsn),nhnuc(mxrsn),irna(mxres-23),
     &                inuc(2,mxnucl,mxrsn),ihnuc(2,mxhnuc,mxrsn)
      common /chgbck/ qat(numat1)
      common /zmsbck/ lwrit(numat1)

      common /elmcom/ vdwr(mxel),vrad(mxel),icol(mxel)
      common /multim/ imulm, nmulm,ihasqm(mxmmul)
      common /charge/ ihasq
      common /debug/ idebug

      common /metexc/ qexcl(mexcl),ianexc(mexcl)
      character*5 mol2
      character*20 ambstr
      character*2 gffstr
      character*28 gffext(mxgff)
      character*320 tmpfil
      common /tmpfil/ tmpfil
      
      common /ftypes/ ihasl(11),mol2(mxmol2),ambstr(mxamb)
      character*3 pdbsym,hsym,ambtnk
      common /symbol/ pdbsym(mxsym),hsym(mxhsym),
     &                ambtnk(mxamb),gffstr(mxgff)
      integer ambvdt
      common /fcharg/ ambchg(mxamb),ambvw1(mxambc),ambvw2(mxambc),
     &                gfvdw(2,mxgff),ambvdt(mxamb),cysneg(9)
      common /zmfrst/ ihaszm, nz, mxzat
      common /hring/  lring(numat1)
      common /selatm/ jring(numat1)
      character*137 line
      common /curlin/ line
      character*256 linput
      character*75 argstr
      character*1024 curdir
      common /cwd/ curdir
      common /pdbon/  ipdbon

      real energy
      common /ener/iener,energy,lig(3),iprot(3),iconf

      parameter (numcal=50000)
      parameter (mxchai=50)
      parameter (mxheta=150)
      integer reson
      character*1 achain
      common /calf/ istiff,
     &              icalf(6,numcal),ncalf,ianf(mxchai),islu(mxchai),
     &              nchain,iamino(numcal),ihet(mxheta),
     &              iclhet(mxheta),reson(numcal),issdon,
     &              icxp(numcal),icyp(numcal),
     &              iams(numcal),ihets(mxheta),ibck(4),
     &              isal(numcal),irsnr(numcal),lab(numcal),ihashb,
     &              ishoh,ision,achain(numcal)

      integer doinp,getinp
      character*3 hetz
      common /clfstr/ ihashz,ihetq(mxheta),ihqset(mxheta),ihhadd(mxheta)
     &                ,labhet(mxheta),ilcset,ligcat(mxheta),hetz(mxheta)
      character*3 aminos
      common /amino/aminos(mxres)
      character*2 elemnt
      common /elem/elemnt(mxel)
      common /surf / natorg,nosncd
      common /rdwr/ iun1,iun2,iun3,iun4,iun5
      character moldroot*512
      common /mldroot/ moldroot
      common /srfbck/ isurf(numat1)

      character esc, etx, lf, cr, eot, gs, ff, fs, us

      common /mfdata/ nmols,imol,iendmf,ielin,maxmol,mollin

      data aminos/'GLY','ALA','SER','CYS','THR','ILE','VAL','MET',
     &            'ASP','ASN','LEU','LYS','GLU','GLN','PRO','ARG',
     &            'HIS','PHE','TYR','TRP','ASX','GLX','HYP','  A',
     &            '  C','  G','  T','  U','1MA','5MC','OMC','1MG',
     &            '2MG','M2G','7MG','OMG',' YG','  I',' +U','H2U',
     &            '5MU','PSU'/

      data pdbsym/
     &   'N  ','CA ','C  ','O  ','CB ','CG ','CG1','CG2','CD ','CD1',
     &   'CD2','CE ','CE1','CE2','CE3','CH2','CZ ','CZ2','CZ3','ND1',
     &   'ND2','NE ','NE1','NE2','NH1','NH2','NZ ','OD ','OD1','OD2',
     &   'OG ','OG1','OH ','OE1','OE2','SD ','SG ','OXT','AD1','AD2',
     &   'AE1','AE2','P  ','O1P','O2P','O5*','C5*','C4*','O4*','C3*',
     &   'O3*','C2*','O2*','C1*','C2 ','C4 ','C5 ','C6 ','C8 ','N1 ',
     &   'N2 ','N3 ','N4 ','N6 ','N7 ','N9 ','O2 ','O4 ','O6 ','C5M',
     &   'C1 ','C5A','C2A','C2B','C7 ','O3P','O5T','O3T','CM1','CM2',
     &   'CM3','CM4','CM5','CM6','CM7','CM8','CM9','C3 ','C10','C11',
     &   'C12','C13','C14','C15','C16','O17','O18','C19','N20','C21',
     &   'O22','O23','C24'/

      data hsym/
     &   'H  ','HA ','HB ','HG ','HG1','HG2','HD ','HD1','HD2','HE ',
     &   'HE1','HE2','HE3','HZ ','HZ1','HZ2','HZ3','HH ','HH1','HH2',
     &   'H5*','H4*','H3*','H2*','H1*','HO2','H1 ','H2 ','H21','H22',
     &   'H3 ','H41','H42','H5 ','H6 ','H61','H62','H8 ','HO3','H5T',
     &   'HN1','HN2','HN3','HN4','HN5','HN6','HN7','HN8','HN9','HM1',
     &   'HM2','HM3','HM4','HM5','HM6','HM7','HM8','HM9','H10','H13',
     &   'H14','H15','H19','H24'/

      data elemnt/' H','He',
     2 'Li','Be',' B',' C',' N',' O',' F','Ne',
     3 'Na','Mg','Al','Si',' P',' S','Cl','Ar',
     4 ' K','Ca','Sc','Ti',' V','Cr','Mn','Fe','Co','Ni','Cu',
     4 'Zn','Ga','Ge','As','Se','Br','Kr',
     5 'Rb','Sr',' Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag',
     5 'Cd','In','Sn','Sb','Te',' I','Xe',
     6 'Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy',
     6 'Ho','Er','Tm','Yb','Lu','Hf','Ta',' W','Re','Os','Ir','Pt',
     6 'Au','Hg','Tl','Pb','Bi','Po','At','Rn',
     7 'Fr','Ra','Ac','Th','Pa',' U','Np','Pu','Am','Cm','Bk','Cf',
     8 'XX','  '/

c r-adenosine

      data ((inuc(i,j,1),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1001,47,1002,48,1005,49,1007,
     & 50,1010,51,1016,52,1012,53,1014,54,1008,55,1023,56,1018,
     & 57,1019,58,1025,59,1021,60,1024,62,1022,64,1027,65,1020,
     & 66,1017,34*0/

      data ((ihnuc(i,j,1),i=1,2),j=1,mxhnuc) /
     & 61,1003,62,1004,64,1006,67,1011,70,1013,73,1009,
     & 76,1015,82,1026,112,1030,136,1028,137,1029,
     & 103,1028,104,1029,28*0/

c r-guanosine

      data ((inuc(i,j,2),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1031,47,1032,48,1035,49,1037,
     & 50,1040,51,1046,52,1042,53,1044,54,1038,55,1053,56,1048,
     & 57,1049,58,1055,59,1051,60,1054,61,1057,62,1052,65,1050,
     & 66,1047,69,1060,32*0/

      data ((ihnuc(i,j,2),i=1,2),j=1,mxhnuc) /
     & 61,1033,62,1034,64,1036,67,1041,70,1043,73,1039,76,1045,
     & 112,1061,121,1056,124,1058,125,1059,
     & 79,1056,82,1058,83,1059,26*0/

c r-cytosine

      data ((inuc(i,j,3),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1062,47,1063,48,1066,49,1068,
     & 50,1071,51,1077,52,1073,53,1075,54,1069,55,1079,56,1081,
     & 57,1082,58,1083,60,1078,62,1080,63,1085,67,1084,38*0/

      data ((ihnuc(i,j,3),i=1,2),j=1,mxhnuc) /
     & 61,1064,62,1065,64,1067,67,1072,70,1074,73,1070,76,1076,
     & 100,1088,103,1089,130,1086,131,1087,32*0/

c r-uracil

      data ((inuc(i,j,4),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1090,47,1091,48,1094,49,1096,
     & 50,1099,51,1105,52,1101,53,1103,54,1097,55,1107,56,1109,
     & 57,1110,58,1111,60,1106,62,1108,67,1112,68,1114,38*0/

      data ((ihnuc(i,j,4),i=1,2),j=1,mxhnuc) /
     & 61,1092,62,1093,64,1095,67,1100,70,1102,73,1098,76,1104,
     & 100,1115,103,1116,127,1113,91,1113,32*0/

c d-adenosine

      data ((inuc(i,j,5),i=1,2),j=1,mxnucl) /
     & 43,1242,44,1243,45,1243,46,1117,47,1118,48,1121,49,1123,
     & 50,1126,51,1131,52,1128,54,1124,55,1138,56,1133,57,1134,
     & 58,1140,59,1136,60,1139,62,1137,64,1142,65,1135,66,1132,
     & 36*0/

      data ((ihnuc(i,j,5),i=1,2),j=1,mxhnuc) /
     & 61,1119,62,1120,64,1122,67,1127,70,1129,71,1130,73,1125,
     & 82,1141,112,1145,136,1143,137,1144,103,1143,104,1144,28*0/

c d-guanosine

      data ((inuc(i,j,6),i=1,2),j=1,mxnucl) /
     & 43,1242,44,1243,45,1243,46,1146,47,1147,48,1150,49,1152,
     & 50,1155,51,1160,52,1157,54,1153,55,1167,56,1162,57,1163,
     & 58,1169,59,1165,60,1168,61,1171,62,1166,65,1164,66,1161,
     & 69,1174,34*0/

      data ((ihnuc(i,j,6),i=1,2),j=1,mxhnuc) /
     & 61,1148,62,1149,64,1151,67,1156,70,1158,71,1159,73,1154,
     & 112,1175,121,1170,124,1172,125,1173,
     & 79,1170,82,1172,83,1173,26*0/

c d-cytosine

      data ((inuc(i,j,7),i=1,2),j=1,mxnucl) /
     & 43,1242,44,1243,45,1243,46,1176,47,1177,48,1180,49,1182,
     & 50,1185,51,1190,52,1187,54,1183,55,1192,56,1194,57,1195,
     & 58,1196,60,1191,62,1193,63,1198,67,1197,40*0/

      data ((ihnuc(i,j,7),i=1,2),j=1,mxhnuc) /
     & 61,1178,62,1179,64,1181,67,1186,70,1188,71,1189,73,1184,
     & 100,1201,103,1202,130,1199,131,1200,32*0/

c d-thymine

      data ((inuc(i,j,8),i=1,2),j=1,mxnucl) /
     & 43,1242,44,1243,45,1243,46,1203,47,1204,48,1207,49,1209,
     & 50,1212,51,1217,52,1214,54,1210,55,1219,56,1221,57,1222,
     & 58,1223,70,1227,75,1227,83,1227,85,1227,60,1218,62,1220,
     & 67,1224,68,1226,32*0/

      data ((ihnuc(i,j,8),i=1,2),j=1,mxhnuc) /
     & 61,1205,62,1206,64,1208,67,1213,70,1215,71,1216,73,1211,
     & 160,1228,161,1228,162,1228,103,1229,127,1225,91,1225,
     & 166,1228,167,1228,168,1228,22*0/

c 1MA

      data ((inuc(i,j,9),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1254,47,1255,48,1258,49,1260,
     & 50,1263,51,1269,52,1265,53,1267,54,1261,55,1276,56,1271,
     & 57,1272,58,1278,59,1274,60,1277,62,1275,64,1280,65,1273,
     & 66,1270,79,1283,32*0/

      data ((ihnuc(i,j,9),i=1,2),j=1,mxhnuc) /
     & 61,1256,62,1257,64,1259,67,1264,70,1266,73,1262,
     & 76,1268,82,1279,112,1282,136,1281,137,1281,
     & 148,1284,149,1284,150,1284,103,1281,104,1281,22*0/

c 5MC

      data ((inuc(i,j,10),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1285,47,1286,48,1288,49,1290,
     & 50,1293,51,1299,52,1295,53,1297,54,1291,55,1301,56,1303,
     & 57,1304,58,1305,60,1300,62,1302,63,1308,67,1307,83,1310,
     & 36*0/

      data ((ihnuc(i,j,10),i=1,2),j=1,mxhnuc) /
     & 61,1287,62,1287,64,1289,67,1294,70,1296,73,1292,76,1298,
     & 103,1306,130,1309,131,1309,160,1311,161,1311,162,1311,28*0/

c OMC

      data ((inuc(i,j,11),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1312,47,1313,48,1315,49,1317,
     & 50,1320,51,1325,52,1322,53,1324,54,1318,55,1327,56,1330,
     & 57,1333,58,1335,60,1326,62,1329,63,1331,67,1328,80,1337,
     & 36*0/

      data ((ihnuc(i,j,11),i=1,2),j=1,mxhnuc) /
     & 61,1314,62,1314,64,1316,67,1321,70,1323,73,1319,103,1336,
     & 100,1334,130,1332,131,1332,151,1338,152,1338,153,1338,28*0/

c 2MG

      data ((inuc(i,j,12),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1339,47,1340,48,1342,49,1344,
     & 50,1347,51,1353,52,1349,53,1351,54,1345,55,1361,56,1355,
     & 57,1356,58,1364,59,1358,60,1362,61,1366,62,1360,65,1357,
     & 66,1354,69,1365,80,1368,30*0/

      data ((ihnuc(i,j,12),i=1,2),j=1,mxhnuc) /
     & 61,1341,62,1341,64,1343,67,1348,70,1350,73,1346,76,1352,
     & 112,1359,121,1363,124,1367,125,1367,
     & 151,1369,152,1369,153,1369,79,1363,82,1367,83,1367,20*0/

c M2G

      data ((inuc(i,j,13),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1370,47,1371,48,1373,49,1375,
     & 50,1378,51,1384,52,1380,53,1382,54,1376,55,1391,56,1386,
     & 57,1387,58,1393,59,1389,60,1392,61,1397,62,1390,65,1388,
     & 66,1385,69,1394,79,1398,80,1398,28*0/


      data ((ihnuc(i,j,13),i=1,2),j=1,mxhnuc) /
     & 61,1372,62,1372,64,1374,67,1379,70,1381,73,1377,76,1383,
     & 112,1396,121,1395,148,1399,149,1399,
     & 150,1399,151,1399,152,1399,153,1399,
     & 79,1395,22*0/

c 7MG

      data ((inuc(i,j,14),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1400,47,1401,48,1403,49,1405,
     & 50,1408,51,1414,52,1410,53,1412,54,1406,55,1421,56,1416,
     & 57,1417,58,1423,59,1419,60,1422,61,1427,62,1420,65,1418,
     & 66,1415,69,1424,85,1429,30*0/

      data ((ihnuc(i,j,14),i=1,2),j=1,mxhnuc) /
     & 61,1402,62,1402,64,1404,67,1409,70,1411,73,1407,76,1413,
     & 112,1426,121,1425,124,1428,125,1428,
     & 166,1430,167,1430,168,1430,
     & 79,1425,82,1428,83,1428,20*0/

c OMG

      data ((inuc(i,j,15),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1431,47,1432,48,1434,49,1436,
     & 50,1439,51,1444,52,1441,53,1443,54,1437,55,1451,56,1446,
     & 57,1447,58,1453,59,1449,60,1452,61,1457,62,1450,65,1448,
     & 66,1445,69,1454,80,1459,30*0/

      data ((ihnuc(i,j,15),i=1,2),j=1,mxhnuc) /
     & 61,1433,62,1433,64,1435,67,1440,70,1442,73,1438,
     & 112,1456,121,1455,124,1458,125,1458,
     & 151,1460,152,1460,153,1460,
     & 79,1455,82,1458,83,1458,22*0/

c YG

      data ((inuc(i,j,16),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1461,47,1462,48,1464,49,1466,
     & 50,1469,51,1475,52,1471,53,1473,54,1467,55,1482,56,1477,
     & 57,1478,58,1484,59,1480,60,1483,61,1486,62,1481,65,1479,
     & 66,1476,69,1485,88,1490,89,1492,90,1487,91,1488,92,1494,
     & 93,1496,94,1498,95,1500,96,1501,97,1502,98,1503,99,1505,
     & 100,1507,101,1508,102,1509,103,1510/

      data ((ihnuc(i,j,16),i=1,2),j=1,mxhnuc) /
     & 61,1463,62,1463,64,1465,67,1470,70,1472,73,1468,76,1474,
     & 112,1489,91,1491,92,1491,93,1491,124,1506,175,1493,
     & 176,1493,177,1493,178,1495,179,1495,181,1497,182,1497,
     & 184,1499,187,1504,188,1504,189,1504,190,1511,191,1511,
     & 192,1511,82,1506/

c H2U

      data ((inuc(i,j,17),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1512,47,1513,48,1515,49,1517,
     & 50,1520,51,1526,52,1522,53,1524,54,1518,55,1528,56,1530,
     & 57,1531,58,1532,60,1527,62,1529,67,1533,68,1534,38*0/

      data ((ihnuc(i,j,17),i=1,2),j=1,mxhnuc) /
     & 61,1514,62,1514,64,1516,67,1521,70,1523,73,1519,76,1525,
     & 100,1536,101,1536,103,1537,104,1537,127,1535,91,1537,
     & 28*0/

c 5MU

      data ((inuc(i,j,18),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1538,47,1539,48,1541,49,1543,
     & 50,1546,51,1552,52,1548,53,1550,54,1544,55,1554,56,1556,
     & 57,1557,58,1558,60,1553,62,1555,67,1559,68,1560,83,1563,
     & 36*0/

      data ((ihnuc(i,j,18),i=1,2),j=1,mxhnuc) /
     & 61,1540,62,1540,64,1542,67,1547,70,1549,73,1545,76,1551,
     & 103,1562,127,1561,91,1561,160,1564,161,1564,162,1564,
     & 28*0/

c PSU

      data ((inuc(i,j,19),i=1,2),j=1,mxnucl) /
     & 43,1230,44,1231,45,1231,46,1565,47,1566,48,1568,49,1570,
     & 50,1573,51,1579,52,1575,53,1577,54,1571,55,1583,56,1585,
     & 57,1580,58,1581,60,1582,62,1584,67,1586,68,1587,38*0/

      data ((ihnuc(i,j,19),i=1,2),j=1,mxhnuc) /
     & 61,1567,62,1567,64,1569,67,1574,70,1576,73,1572,76,1578,
     & 103,1588,121,1589,127,1590,91,1590,32*0/

      data (ambchg(i),i=1,60) /
     &  -0.4157 , -0.0252 ,  0.5973 ,  0.2719 , -0.5679 ,  0.0698
     &, -0.4157 ,  0.0337 ,  0.5973 ,  0.2719 , -0.5679 ,  0.0823
     &, -0.1825 ,  0.0603 , -0.4157 , -0.0875 ,  0.5973 ,  0.2719
     &, -0.5679 ,  0.0969 ,  0.2985 , -0.0297 , -0.3192 ,  0.0791
     &, -0.3192 ,  0.0791 , -0.4157 , -0.0518 ,  0.5973 ,  0.2719
     &, -0.5679 ,  0.0922 , -0.1102 ,  0.0457 ,  0.3531 , -0.0361
     &, -0.4121 ,  0.1000 , -0.4121 ,  0.1000 , -0.4157 , -0.0597
     &,  0.5973 ,  0.2719 , -0.5679 ,  0.0869 ,  0.1303 ,  0.0187
     &, -0.0430 ,  0.0236 , -0.3204 ,  0.0882 , -0.0660 ,  0.0186
     &, -0.4157 , -0.0249 ,  0.5973 ,  0.2719 , -0.5679 ,  0.0843/

      data (ambchg(i),i=61,120) /
     &   0.2117 ,  0.0352 , -0.6546 ,  0.4275 , -0.4157 , -0.0389
     &,  0.5973 ,  0.2719 , -0.5679 ,  0.1007 ,  0.3654 ,  0.0043
     &, -0.6761 ,  0.4102 , -0.2438 ,  0.0642 , -0.4157 ,  0.0213
     &,  0.5973 ,  0.2719 , -0.5679 ,  0.1124 , -0.1231 ,  0.1112
     &, -0.3119 ,  0.1933 , -0.4157 ,  0.0429 ,  0.5973 ,  0.2719
     &, -0.5679 ,  0.0766 , -0.0790 ,  0.0910 , -0.1081 , -0.2548
     &, -0.0266 ,  0.5896 , -0.5748 ,  0.0641 , -0.0070 ,  0.0253
     &,  0.0189 ,  0.0213 ,  0.0192 ,  0.0391 , -0.4157 , -0.0024
     &,  0.5973 ,  0.2719 , -0.5679 ,  0.0978 , -0.0343 ,  0.0295
     &,  0.0118 , -0.1256 ,  0.1330 , -0.1704 ,  0.1430 , -0.1072/

      data (ambchg(i),i=121,180) /
     &   0.1297 , -0.4157 , -0.0014 ,  0.5973 ,  0.2719 , -0.5679
     &,  0.0876 , -0.0152 ,  0.0295 , -0.0011 , -0.1906 ,  0.1699
     &, -0.2341 ,  0.1656 ,  0.3226 , -0.5579 ,  0.3992 , -0.4157
     &, -0.0275 ,  0.5973 ,  0.2719 , -0.5679 ,  0.1123 , -0.0050
     &,  0.0339 , -0.1415 , -0.1638 ,  0.2062 ,  0.1243 , -0.3418
     &,  0.3412 ,  0.1380 , -0.2387 ,  0.1700 , -0.2601 ,  0.1572
     &, -0.1972 ,  0.1447 , -0.1134 ,  0.1417 , -0.3479 , -0.1354
     &,  0.7341 ,  0.2747 , -0.5894 ,  0.1212 , -0.0414 ,  0.0810
     &, -0.0012 , -0.1513 ,  0.3866 , -0.1141 ,  0.2317 , -0.0170
     &,  0.2681 , -0.1718 ,  0.3911 , -0.4157 ,  0.0188 ,  0.5973/

      data (ambchg(i),i=181,240) /
     &   0.2719 , -0.5679 ,  0.0881 , -0.0462 ,  0.0402 , -0.0266
     &, -0.3811 ,  0.3649 ,  0.1292 ,  0.1147 ,  0.2057 ,  0.1392
     &, -0.5727 , -0.4157 , -0.0581 ,  0.5973 ,  0.2719 , -0.5679
     &,  0.1360 , -0.0074 ,  0.0367 ,  0.1868 , -0.5432 , -0.2207
     &,  0.1862 ,  0.1635 ,  0.1435 , -0.2795 ,  0.3339 , -0.5163
     &,  0.0381 ,  0.5366 ,  0.2936 , -0.5819 ,  0.0880 , -0.0303
     &, -0.0122 ,  0.7994 , -0.8014 , -0.4157 ,  0.0143 ,  0.5973
     &,  0.2719 , -0.5679 ,  0.1048 , -0.2041 ,  0.0797 ,  0.7130
     &, -0.5931 , -0.9191 ,  0.4196 , -0.5163 ,  0.0397 ,  0.5366
     &,  0.2936 , -0.5819 ,  0.1105 ,  0.0560 , -0.0173 ,  0.0136/

      data (ambchg(i),i=241,300) /
     &  -0.0425 ,  0.8054 , -0.8188 , -0.4157 , -0.0031 ,  0.5973
     &,  0.2719 , -0.5679 ,  0.0850 , -0.0036 ,  0.0171 , -0.0645
     &,  0.0352 ,  0.6951 , -0.6086 , -0.9407 ,  0.4251 , -0.4157
     &, -0.0237 ,  0.5973 ,  0.2719 , -0.5679 ,  0.0880 ,  0.0342
     &,  0.0241 ,  0.0018 ,  0.0440 , -0.2737 , -0.0536 ,  0.0684
     &, -0.3479 , -0.2400 ,  0.7341 ,  0.2747 , -0.5894 ,  0.1426
     &, -0.0094 ,  0.0362 ,  0.0187 ,  0.0103 , -0.0479 ,  0.0621
     &, -0.0143 ,  0.1135 , -0.3854 ,  0.3400 , -0.3479 , -0.2637
     &,  0.7341 ,  0.2747 , -0.5894 ,  0.1560 , -0.0007 ,  0.0327
     &,  0.0390 ,  0.0285 ,  0.0486 ,  0.0687 , -0.5295 ,  0.3456/

      data (ambchg(i),i=301,360) /
     &   0.8076 , -0.8627 ,  0.4478 , -0.3479 , -0.2400 ,  0.7341
     &,  0.2747 , -0.5894 ,  0.1426 ,  0.0099 ,  0.0362 , -0.0279
     &,  0.0621 , -0.0143 ,  0.1135 , -0.3854 ,  0.3400 , -0.4157
     &,  0.1032 ,  0.5973 ,  0.2719 , -0.5679 , -0.2503 ,  0.0853
     &, -0.4157 , -0.0371 ,  0.5973 ,  0.2719 , -0.5679 ,  0.0850
     &, -0.0036 ,  0.0171 , -0.0645 ,  0.0352 ,  0.6000 , -0.5700
     &,  0.5500 ,  0.0000 , -0.5500 , -0.3662 ,  0.1123 ,  0.5972
     &, -0.5679 , -0.8400 ,  0.4200 , -0.4157 ,  0.2719 , -0.1490
     &,  0.0976 ,  0.2943 , -0.0100 ,  0.6163 ,  0.1642 , -0.5722
     &,  0.0895 ,  0.1414 ,  0.1281 ,  0.6163 ,  0.1997 , -0.5722/

      data (ambchg(i),i=361,420) /
     &   0.0889 ,  0.0577 ,  0.0023 ,  0.6163 ,  0.2272 , -0.5722
     &,  0.1093 ,  0.1010 ,  0.0343 ,  0.6123 ,  0.2148 , -0.5713
     &,  0.1053 ,  0.0311 ,  0.0389 ,  0.6123 ,  0.2329 , -0.5713
     &,  0.1031 ,  0.1849 ,  0.0684 ,  0.6163 ,  0.1898 , -0.5722
     &,  0.0782 ,  0.1812 ,  0.0332 ,  0.6163 ,  0.1934 , -0.5722
     &,  0.1087 ,  0.1325 ,  0.0978 ,  0.6123 ,  0.2023 , -0.5713
     &,  0.1411 ,  0.2096 ,  0.1138 ,  0.6163 ,  0.1815 , -0.5713
     &,  0.0922 , -0.2020 ,  0.1589 ,  0.5260 ,  0.3120 , -0.5000
     &,  0.1000 , -0.0120 ,  0.1000 ,  0.1737 ,  0.0859 ,  0.6123
     &,  0.1921 , -0.5713 ,  0.1041 ,  0.1940 ,  0.0766 ,  0.6123/

      data (ambchg(i),i=421,480) /
     &   0.1873 , -0.5713 ,  0.0983 ,  0.1913 ,  0.0555 ,  0.6123
     &,  0.1888 , -0.5713 ,  0.1162 ,  0.2560 ,  0.0653 ,  0.7214
     &,  0.1704 , -0.6013 ,  0.1047 ,  0.1542 ,  0.1126 ,  0.6123
     &,  0.1963 , -0.5713 ,  0.0958 ,  0.1472 ,  0.0325 ,  0.6123
     &,  0.2016 , -0.5713 ,  0.1380 ,  0.0782 ,  0.0326 ,  0.5621
     &,  0.2200 , -0.5889 ,  0.1141 ,  0.1801 ,  0.0811 ,  0.6163
     &,  0.1921 , -0.5722 ,  0.1231 ,  0.0017 ,  0.0698 ,  0.5621
     &,  0.2391 , -0.5889 ,  0.1202 ,  0.1493 ,  0.0769 ,  0.6123
     &,  0.1996 , -0.5713 ,  0.1015 ,  0.1592 ,  0.0429 ,  0.6123
     &,  0.1984 , -0.5713 ,  0.1116 ,  0.0966 , -0.0101 ,  0.7214/

      data (ambchg(i),i=481,540) /
     &   0.2165 , -0.6013 ,  0.1180 ,  0.1305 , -0.0359 ,  0.7214
     &,  0.2083 , -0.6013 ,  0.1242 ,  0.0966 , -0.0101 ,  0.7214
     &,  0.2165 , -0.6013 ,  0.1180 ,  0.1000 ,  0.2447 ,  0.6163
     &,  0.2000 , -0.5722 , -0.3821 , -0.2493 ,  0.7231 ,  0.2681
     &, -0.7855 ,  0.1056 , -0.3821 , -0.1532 ,  0.7731 ,  0.2681
     &, -0.8055 ,  0.1067 , -0.3821 , -0.3352 ,  0.8350 ,  0.2681
     &, -0.8173 ,  0.1438 , -0.3821 , -0.2874 ,  0.8326 ,  0.2681
     &, -0.8199 ,  0.1346 , -0.3821 , -0.3070 ,  0.8343 ,  0.2681
     &, -0.8190 ,  0.1375 , -0.3821 , -0.2563 ,  0.8113 ,  0.2681
     &, -0.8132 ,  0.1304 , -0.3821 , -0.2315 ,  0.7810 ,  0.2681/

      data (ambchg(i),i=541,600) /
     &  -0.8044 ,  0.1207 , -0.3821 , -0.1598 ,  0.7497 ,  0.2681
     &, -0.7981 ,  0.1396 , -0.3821 , -0.1283 ,  0.7618 ,  0.2681
     &, -0.8041 ,  0.0938 , -0.2802 , -0.1236 ,  0.6631 , -0.7697
     &,  0.0776 , -0.3821 , -0.1756 ,  0.7660 ,  0.2681 , -0.8026
     &,  0.1098 , -0.3821 , -0.1911 ,  0.7817 ,  0.2681 , -0.8070
     &,  0.1092 , -0.3821 , -0.2064 ,  0.7658 ,  0.2681 , -0.8011
     &,  0.1272 , -0.3481 , -0.1503 ,  0.8032 ,  0.2764 , -0.8177
     &,  0.1115 , -0.3821 , -0.1618 ,  0.7615 ,  0.2681 , -0.8016
     &,  0.1100 , -0.3821 , -0.2661 ,  0.7916 ,  0.2681 , -0.8065
     &,  0.1650 , -0.5192 , -0.1810 ,  0.7256 ,  0.3055 , -0.7887/

      data (ambchg(i),i=601,659) /
     &   0.1046 , -0.3821 , -0.1927 ,  0.8050 ,  0.2681 , -0.8147
     &,  0.1358 , -0.5192 , -0.2000 ,  0.7420 ,  0.3055 , -0.7930
     &,  0.1399 , -0.3821 , -0.2108 ,  0.7775 ,  0.2681 , -0.8042
     &,  0.1232 , -0.3821 , -0.2441 ,  0.8013 ,  0.2681 , -0.8105
     &,  0.1277 , -0.3481 , -0.2964 ,  0.8488 ,  0.2764 , -0.8252
     &,  0.1438 , -0.3481 , -0.3117 ,  0.8557 ,  0.2764 , -0.8266
     &,  0.1447 , -0.3481 , -0.2964 ,  0.8488 ,  0.2764 , -0.8252
     &,  0.1438 , -0.3821 , -0.0572 ,  0.8000 ,  0.2681 , -0.8200
     &, -0.8340 ,  0.4170 ,  1.0000 ,  1.0000 ,  1.0000 ,  1.0000
     &,  1.0000 ,  2.0000 ,  2.0000 ,  2.0000 , -1.0000/

c ASP neutral
      data (ambchg(i),i=660,671) /
     &  -0.4157 ,  0.0341 ,  0.5973 ,  0.2719 , -0.5679 ,  0.0864
     &, -0.0316 ,  0.0488 ,  0.6462 , -0.5554 , -0.6376 ,  0.4747/

c GLU neutral
      data (ambchg(i),i=672,685) /
     &  -0.4157 ,  0.0145 ,  0.5973 ,  0.2719 , -0.5679 ,  0.0779
     &, -0.0071 ,  0.0256 , -0.0174 ,  0.0430 ,  0.6801 , -0.5838
     &, -0.6511 ,  0.4641/

c LYS neutral
      data (ambchg(i),i=686,701) /
     &  -0.4157 , -0.07206,  0.5973 ,  0.2719 , -0.5679 ,  0.0994
     &, -0.04845,  0.0340 , 0.06612 , 0.01041 ,-0.03768 , 0.01155
     &,  0.32604, -0.03358, -1.03581, 0.38604/

c CYS Negative

      data (cysneg(i),i=1,9) /
     & -0.4937, -0.2870, 0.6731, 0.3018, -0.5854, 0.1203, 0.0935,
     &  0.0125, -0.8476/

      data (ambchg(i),i=702,1000) / 299*0.0/

      data (ambchg(i),i=1001,1030) /
     & -0.4989,  0.0558,  0.0679,  0.0679,  0.1065,  0.1174,
     & -0.3548,  0.0394,  0.2007,  0.2022,  0.0615,  0.0670,
     &  0.0972, -0.6139,  0.4186, -0.5246, -0.0251,  0.3053,
     &  0.0515, -0.6073,  0.2006, -0.6997,  0.5875, -0.7615,
     &  0.7009,  0.0473, -0.9019,  0.4115,  0.4115,  0.1553/

      data (ambchg(i),i=1031,1061) /
     & -0.4989,  0.0558,  0.0679,  0.0679,  0.1065,  0.1174,
     & -0.3548,  0.0191,  0.2006,  0.2022,  0.0615,  0.0670,
     &  0.0972, -0.6139,  0.4186, -0.5246,  0.0492,  0.1222,
     &  0.1744, -0.5709,  0.1374, -0.6323,  0.7657, -0.4787,
     &  0.4770,  0.3424, -0.9672,  0.4364,  0.4364, -0.5597,
     &  0.1640/

      data (ambchg(i),i=1062,1089) /
     & -0.4989,  0.0558,  0.0679,  0.0679,  0.1065,  0.1174,
     & -0.3548,  0.0066,  0.2029,  0.2022,  0.0615,  0.0670,
     &  0.0972, -0.6139,  0.4186, -0.5246, -0.0484,  0.7538,
     & -0.7584,  0.8185, -0.5215,  0.0053, -0.6252, -0.9530,
     &  0.4234,  0.4234,  0.1928,  0.1958/

      data (ambchg(i),i=1090,1116) /
     & -0.4989,  0.0558,  0.0679,  0.0679,  0.1065,  0.1174,
     & -0.3548,  0.0674,  0.1824,  0.2022,  0.0615,  0.0670,
     &  0.0972, -0.6139,  0.4186, -0.5246,  0.0418,  0.4687,
     & -0.3549,  0.5952, -0.3635, -0.1126, -0.5477,  0.3154,
     & -0.5761,  0.1811,  0.2188/

      data (ambchg(i),i=1117,1145) /
     & -0.4954, -0.0069,  0.0754,  0.0754,  0.1629,  0.1176,
     & -0.3691,  0.0431,  0.1838,  0.0713,  0.0985, -0.0854,
     &  0.0718,  0.0718, -0.5232, -0.0268,  0.3800,  0.0725,
     & -0.6175,  0.1607, -0.7417,  0.5716, -0.7624,  0.6897,
     &  0.0598, -0.9123,  0.4167,  0.4167,  0.1877/

      data (ambchg(i),i=1146,1175) /
     & -0.4954, -0.0069,  0.0754,  0.0754,  0.1629,  0.1176,
     & -0.3691,  0.0358,  0.1746,  0.0713,  0.0985, -0.0854,
     &  0.0718,  0.0718, -0.5232,  0.0577,  0.1814,  0.1991,
     & -0.5725,  0.0736, -0.6636,  0.7432, -0.5053,  0.4918,
     &  0.3520, -0.9230,  0.4235,  0.4235, -0.5699,  0.1997/

      data (ambchg(i),i=1176,1202) /
     & -0.4954, -0.0069,  0.0754,  0.0754,  0.1629,  0.1176,
     & -0.3691, -0.0116,  0.1963,  0.0713,  0.0985, -0.0854,
     &  0.0718,  0.0718, -0.5232, -0.0339,  0.7959, -0.7748,
     &  0.8439, -0.5222, -0.0183, -0.6548, -0.9773,  0.4314,
     &  0.4314,  0.1863,  0.2293/

      data (ambchg(i),i=1203,1229) /
     & -0.4954, -0.0069,  0.0754,  0.0754,  0.1629,  0.1176,
     & -0.3691,  0.0680,  0.1804,  0.0713,  0.0985, -0.0854,
     &  0.0718,  0.0718, -0.5232, -0.0239,  0.5677, -0.4340,
     &  0.5194,  0.0025, -0.2209, -0.5881,  0.3420, -0.5563,
     & -0.2269,  0.0770,  0.2607/

      data (ambchg(i),i=1230,1241) /
     &  1.1662, -0.7760, -0.6223,  0.4295, -0.6328,  0.9000,
     & -0.8200, -0.6541,  0.4376, -0.6565,  0.9000, -0.8200/

      data (ambchg(i),i=1242,1253) /
     &  1.1659, -0.7761, -0.6318,  0.4422, -0.6296,  0.9000,
     & -0.8200, -0.6549,  0.4396, -0.6553,  0.9000, -0.8200/

      data (ambvw1(i),i=1,49) /
     & 1.9080, 1.9080, 1.9080, 1.9080, 1.9080, 1.9080, 1.9080,
     & 1.9080, 1.9080, 1.9080, 1.9080, 1.9080, 1.9080, 1.8240,
     & 1.8240, 1.8240, 1.8240, 1.8240, 1.8240, 1.8750, 1.7683,
     & 1.7210, 1.6837, 1.6612, 1.6612, 2.0000, 2.0000, 2.1000,
     & 0.6000, 0.0001, 0.0001, 0.6000, 1.4590, 1.4870, 1.3870,
     & 1.2870, 1.1870, 1.1000, 1.4090, 1.3590, 1.1370, 1.8680,
     & 2.6580, 2.9560, 3.3950, 0.7926, 1.7131, 1.1000, 2.4700/

      data (ambvw2(i),i=1,49) /
     & 0.1094, 0.0860, 0.0860, 0.0860, 0.0860, 0.0860, 0.0860,
     & 0.0860, 0.0860, 0.0860, 0.0860, 0.0860, 0.0860, 0.1700,
     & 0.1700, 0.1700, 0.1700, 0.1700, 0.1700, 0.1700, 0.1520,
     & 0.2104, 0.1700, 0.2100, 0.2100, 0.2500, 0.2500, 0.2000,
     & 0.0157, 0.0000, 0.0000, 0.0157, 0.0150, 0.0157, 0.0157,
     & 0.0157, 0.0157, 0.0157, 0.0150, 0.0150, 0.0183, 0.00277,
     & 0.000328, 0.00017, 0.0000806, 0.8947, 0.459789, 
     & 0.0125, 0.1000/

      data (ambvdt(i),i=1,60) /
     & 14, 1, 2,29,24,35,14, 1, 2,29,
     & 24,35, 1,34,14, 1, 2,29,24,35,
     &  1,34, 1,34, 1,34,14, 1, 2,29,
     & 24,35, 1,34, 1,34, 1,34, 1,34,
     & 14, 1, 2,29,24,35, 1,34, 1,34,
     &  1,34, 1,34,14, 1, 2,29,24,35/

      data (ambvdt(i),i=61,120) /
     &  1,35,22,31,14, 1, 2,29,24,35,
     &  1,35,22,31, 1,34,14, 1, 2,29,
     & 24,35, 1,35,27,32,14, 1, 2,29,
     & 24,35, 1,35,26,14, 1, 2,24,35,
     &  1,34, 1,34, 1,35,14, 1, 2,29,
     & 24,35, 1,34, 3, 3,33, 3,33, 3/

      data (ambvdt(i),i=121,180) /
     & 33,14, 1, 2,29,24,35, 1,34, 3,
     &  3,33, 3,33, 3,22,31,14, 1, 2,
     & 29,24,35, 1,34,10, 7,39, 9,15,
     & 29,11, 3,33, 3,33, 3,33, 3,33,
     & 14, 1, 2,29,24,35, 1,34, 5,15,
     & 29, 7,39, 8,40,15,29,14, 1, 2/

      data (ambvdt(i),i=181,240) /
     & 29,24,35, 1,34, 5,15,29, 6,39,
     &  8,40,16,14, 1, 2,29,24,35, 1,
     & 34, 5,16, 7,39, 8,40,15,29,14,
     &  1, 2,29,24,35, 1,34, 2,25,14,
     &  1, 2,29,24,35, 1,34, 2,24,14,
     & 29,14, 1, 2,29,24,35, 1,34, 1/

      data (ambvdt(i),i=241,300) /
     & 34, 2,25,14, 1, 2,29,24,35, 1,
     & 34, 1,34, 2,24,14,29,14, 1, 2,
     & 29,24,35, 1,34, 1,35,26, 1,35,
     & 14, 1, 2,29,24,35, 1,34, 1,34,
     &  1,34, 1,38,20,29,14, 1, 2,29,
     & 24,35, 1,34, 1,34, 1,35,19,29/

      data (ambvdt(i),i=301,360) /
     &  3,19,29,14, 1, 2,29,24,35, 1,
     & 34, 1,34, 1,38,20,29,14, 1, 2,
     & 29,24, 1,34,14, 1, 2,29,24,35,
     &  1,34, 1,34, 2,24, 2, 0,24, 1,
     & 34, 2,24,14,29,14,29, 1,35,20,
     &  1, 2,29,24,35,20, 1, 2,29,24/

      data (ambvdt(i),i=361,420) /
     & 35,20, 1, 2,29,24,35,20, 1, 2,
     & 29,24,35,20, 1, 2,29,24,35,20,
     &  1, 2,29,24,35,20, 1, 2,29,24,
     & 35,20, 1, 2,29,24,35,20, 1, 2,
     & 29,24,35,20, 1, 2,29,24,35, 1,
     & 38,20, 1, 2,29,24,35,20, 1, 2/

      data (ambvdt(i),i=421,480) /
     & 29,24,35,20, 1, 2,29,24,35,20,
     &  1, 2,29,24,35,20, 1, 2,29,24,
     & 35,20, 1, 2,29,24,35,20, 1, 2,
     & 29,24,35,20, 1, 2,29,24,35,20,
     &  1, 2,29,24,35,20, 1, 2,29,24,
     & 35,20, 1, 2,29,24,35,20, 1, 2/

      data (ambvdt(i),i=481,540) /
     & 29,24,35,20, 1, 2,29,24,35,20,
     &  1, 2,29,24,35,20, 1, 2,29,24,
     & 14, 1, 2,29,25,35,14, 1, 2,29,
     & 25,35,14, 1, 2,29,25,35,14, 1,
     &  2,29,25,35,14, 1, 2,29,25,35,
     & 14, 1, 2,29,25,35,14, 1, 2,29/

      data (ambvdt(i),i=541,600) /
     & 25,35,14, 1, 2,29,25,35,14, 1,
     &  2,29,25,35,14, 1, 2,25,35,14,
     &  1, 2,29,25,35,14, 1, 2,29,25,
     & 35,14, 1, 2,29,25,35,14, 1, 2,
     & 29,25,35,14, 1, 2,29,25,35,14,
     &  1, 2,29,25,35,14, 1, 2,29,25/

      data (ambvdt(i),i=601,648) /
     & 35,14, 1, 2,29,25,35,14, 1, 2,
     & 29,25,35,14, 1, 2,29,25,35,14,
     &  1, 2,29,25,35,14, 1, 2,29,25,
     & 35,14, 1, 2,29,25,35,14, 1, 2,
     & 29,25,35,14, 1, 2,29,25/

      data (ambvdt(i),i=649,659) /
     & 32,30,41,42,43,44,45,46,47,48,
     & 49/

c neutral asp, glu, lys
      data (ambvdt(i),i=660,671) /
     & 14, 1, 2,29,24,35, 1,34,
     &  2,24,22,31/
      data (ambvdt(i),i=672,685) /
     & 14, 1, 2,29,24,35, 1,34,
     &  1,34, 2,24,22,31/
      data (ambvdt(i),i=686,701) /
     & 14, 1, 2,29,24,35, 1,34,
     &  1,34, 1,34, 1,38,20,29/

      data (ambvdt(i),i=702,1000) / 299*0/

      data (ambvdt(i),i=1001,1060) /
     & 23,  1, 35, 35,  1, 35, 23,  1, 36,  1,
     & 35,  1, 35, 22, 31, 23, 18,  9,  9, 16,
     & 12, 17, 13, 17,  3, 40, 19, 29, 29, 40,
     & 23,  1, 35, 35,  1, 35, 23,  1, 36,  1,
     & 35,  1, 35, 22, 31, 23, 18,  9,  9, 16,
     & 12, 17,  3, 15,  2, 29, 19, 29, 29, 24/
       
      data (ambvdt(i),i=1061,1120) /
     & 40, 23,  1, 35, 35,  1, 35, 23,  1, 36,
     &  1, 35,  1, 35, 22, 31, 23, 18,  2, 17,
     &  3,  4,  4, 24, 19, 29, 29, 33, 39, 23,
     &  1, 35, 35,  1, 35, 23,  1, 36,  1, 35,
     &  1, 35, 22, 31, 23, 18,  2, 15,  2,  4,
     &  4, 24, 29, 24, 33, 39, 23,  1, 35, 35/

      data (ambvdt(i),i=1121,1180) /
     &  1, 35, 23,  1, 36,  1, 35,  1, 34, 34,
     & 23, 18,  9,  9, 16, 12, 17, 13, 17,  3,
     & 40, 19, 29, 29, 40, 23,  1, 35, 35,  1,
     & 35, 23,  1, 36,  1, 35,  1, 34, 34, 23,
     & 18,  9,  9, 16, 12, 17,  3, 15,  2, 29,
     & 19, 29, 29, 24, 40, 23,  1, 35, 35,  1/
       
      data (ambvdt(i),i=1181,1253) /
     & 35, 23,  1, 36,  1, 35,  1, 34, 34, 23,
     & 18,  2, 17,  3,  4,  4, 24, 19, 29, 29,
     & 33, 39, 23,  1, 35, 35,  1, 35, 23,  1,
     & 36,  1, 35,  1, 34, 34, 23, 18,  2, 15,
     &  2,  4,  4, 24, 29, 24,  1, 34, 39, 28,
     & 25, 22, 31, 23, 28, 25, 22, 31, 23, 28,
     & 25, 28, 25, 22, 31, 23, 28, 25, 22, 31,
     & 23, 28, 25/

c GAFF parameters

      data gfvdw /
     &   0.0000, 0.0000,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.1094,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.9080, 0.0860,
     &   1.3870, 0.0157,
     &   1.2870, 0.0157,
     &   1.1870, 0.0157,
     &   1.4090, 0.0150,
     &   1.3590, 0.0150,
     &   1.4590, 0.0150,
     &   1.4870, 0.0157,
     &   0.6000, 0.0157,
     &   0.0000, 0.0000,
     &   0.6000, 0.0157,
     &   0.6000, 0.0157,
     &   0.0000, 0.0000,
     &   1.1000, 0.0157,
C    &   1.75  , 0.061 ,
     &   1.7029, 0.0832,
     &   1.948 , 0.265 ,
     &   2.22  , 0.320 ,
     &   2.35  , 0.40  ,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.8240, 0.1700,
     &   1.6612, 0.2100,
     &   1.7210, 0.2104,
     &   1.6837, 0.1700,
     &   1.7683, 0.1520,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.1000, 0.2000,
     &   2.0000, 0.2500,
     &   2.0000, 0.2500,
     &   2.0000, 0.2500,
     &   2.0000, 0.2500,
     &   2.0000, 0.2500,
     &   2.0000, 0.2500,
     &   2.0000, 0.2500,
     &   2.0000, 0.2500,
     &   1.9080, 0.0860/

c                 Li+   Na+  Mg+  K+    Ca+  Mn2+,Fe+   Zn+  Rb+   Cs+
      data ianexc / 3,  11,  12,  19,   20,  25,  26,   30,   37,  55/
      data qexcl /1.0, 1.0, 2.0, 1.0,  2.0,  2.0, 2.0, 2.0,  1.0, 1.0/

c sybyl mol2 types

      data mol2 /'Any','Hal','Het','Hev',
     & 'C.3  ','C.2  ','C.1  ','C.ar ','C.cat',
     & 'N.3  ','N.2  ','N.1  ','N.ar ','N.am ','N.pl3','N.4  ',
     & 'O.3  ','O.2  ','O.co2','O.spc','O.t3p',
     & 'S.3  ','S.2  ','S.O  ','S.O2 ','P.3  ',
     & 'H    ','H.spc','H.t3p',
     & 'F    ','Cl   ','Br   ','I    ','Si   ','LP   ','Du   ',
     & 'Na   ','K    ','Ca   ','Li   ','Al   '/

      data gffext /
     &   'placeholder wildcard        ',
     &   'C_Sp2 carbonyl group        ',
     &   'C_Sp                        ',
     &   'C_Sp2                       ',
     &   'C_Sp3                       ',
     &   'pure aromatic Sp2 C         ',
     &   'C_Sp2 conn. rings biphenyl A',
     &   'C_Sp2 conn. rings biphenyl B',
     &   'non-pure aromatic C_sp2    A',
     &   'non-pure aromatic C_sp2    B',
     &   'Inner conjugated C_Sp2     A',
     &   'Inner conjugated C_Sp2     B',
     &   'Inner conjugated C_Sp      A',
     &   'Inner conjugated C_Sp      B',
     &   'C_Sp3 in 3-membered ring    ',
     &   'C_Sp3 in 4-membered ring    ',
     &   'C_Sp2 in 3-membered ring    ',
     &   'C_Sp2 in 4-membered ring    ',
     &   'H -C_aliphatic-  elecwd.gr. ',
     &   'H -C_aliphatic- (el.wd.gr.)2',
     &   'H -C_aliphatic- (el.wd.gr.)3',
     &   'H -C_not_Sp3  -  elecwd.gr. ',
     &   'H -C_not_Sp3  - (el.wd.gr.)2',
     &   'H -C_ar                     ',
     &   'H -C_aliphatic- (el.wd.gr.)0',
     &   'H -N                        ',
     &   'H -O                        ',
     &   'H -P                        ',
     &   'H -S                        ',
     &   'H -O-H (water)              ',
     &   'H -C-(X+)                   ',
     &   'Fluorine                    ',
     &   'Chlorine                    ',
     &   'Bromine                     ',
     &   'Iodine                      ',
     &   'N_Sp2 amide group           ',
     &   'N_Sp                        ',
     &   'N_Sp2 aliphatic- (X)2       ',
     &   'N_Sp3 - (X)3                ',
     &   'N_Sp3 - (X)4                ',
     &   'N_Sp2 - (X)3                ',
     &   'pure aromatic N_Sp2         ',
     &   'non-pure aromatic N_Sp2    A',
     &   'non-pure aromatic N_Sp2    B',
     &   'Inner conjugated N_Sp2     A',
     &   'Inner conjugated N_Sp2     B',
     &   'N_Sp3 amine-arom.ring(s)    ',
     &   'Nitro N                     ',
     &   'O_Sp2                       ',
     &   'O_Sp3 OH                    ',
     &   'O_Sp3 Ether and ester       ',
     &   'O_Sp3 in water              ',
     &   'P-(X)2, like P=C            ',
     &   'P_Sp3-(X)3, such as PH3     ',
     &   'P_Sp2-(X)3, like O=P(CH3)2  ',
     &   'P_Sp2-(X)4, like O=P(OH)3   ',
     &   'pure aromatic P_Sp2         ',
     &   'non-pure aromatic P_Sp2    A',
     &   'non-pure aromatic P_Sp2    B',
     &   'Inner conjugated P_Sp2     A',
     &   'Inner conjugated P_Sp2     B',
     &   'P_Sp2-(X)3, conjugated     A',
     &   'P_Sp2-(X)3, conjugated     B',
     &   'S-X                         ',
     &   'S, R1-S=R2, R1=S=R2         ',
     &   'S-(X)3, 3 conn. atoms,      ',
     &   'S-(X)4, 4 conn. atoms.      ',
     &   'S_Sp3, -S-H                 ',
     &   'S_Sp3, thio-ester and -ether',
     &   'S-(X)3, conjugated          ',
     &   'S-(X)4, conjugated          ',
     &   'C Sp2 carbon in guadinium   '/

      data amboff /1,7,55,77,65,41,15,258,210,220,
     &             27,271,232,244,96,287,161,107,122,138,
CNF N-Term
     &           350,356,380,392,386,374,362,472,448,454,
     &           368,478,460,466,404,484,430,412,418,424,
CNF C-Term
     &           501,507,531,543,537,525,513,620,596,602,
     &           519,626,608,614,555,632,578,560,566,572/
c cystine -SS- 83, HID 174, HIE 190, ORN 300, mALA 314, pyro 321 
c RES N-TERM 352, RES C-TERM 394, GLY N-TERM 346, GLY C-TERM 388
c PRO N-TERM 365, PRO C-TERM 407 (No CB,HB)
c PRO N-TERM CD 371, PRO N-TERM HD 372, PRO C-TERM CD 412,
c PRO C-TERM HD 413

c N CA C O CB (1,2,3,4,5) (gly, NTERM,CTERM; geen 5)
c HN HA HB (1-3,4-5,7-9) (gly, NTERM,CTERM; geen 7-9)
c PRO heeft een geen HN, dus de rest verschuifd

      data ntca /347,353,361,363,362,360,358,383,379,380,359,384,
     &           381,382,366,385,376,373,374,375/

c cystine -SS- 364, HID 377, HIE 378, ORN 386, AIB 387

      data ctca /389,395,403,405,404,402,400,424,420,421,401,425,
     &           422,423,408,426,417,414,415,416/
c cystine -SS- 406, HID 418, HIE 419, ORN 427, AIB 428

      data ncca /0,0,1,1,2,3,2,3,3,3,3,4,4,4,2,6,5,6,7,9,1,5,5/
      data nhha /0,0,1,1,5,8,6,5,0,2,7,9,2,4,8,9,4,5,5,6,0,3,3/

c GLY
      data ((icca(i,j,1),i=1,2),j=1,mxata) /
     & 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,1),i=1,2),j=1,mxatha) /
     & 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c ALA
      data ((icca(i,j,2),i=1,2),j=1,mxata) /
     & 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,2),i=1,2),j=1,mxatha) /
     & 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c SER
      data ((icca(i,j,3),i=1,2),j=1,mxata) /
     & 31,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,3),i=1,2),j=1,mxatha) /
     & 10,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c CYS -SH
      data ((icca(i,j,4),i=1,2),j=1,mxata) /
     & 37,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,4),i=1,2),j=1,mxatha) /
     & 10,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c THR
      data ((icca(i,j,5),i=1,2),j=1,mxata) /
     & 8,75,32,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,5),i=1,2),j=1,mxatha) /
     & 10,74,13,74,16,76,17,76,18,76,0,0,0,0,0,0,0,0/
c ILE
      data ((icca(i,j,6),i=1,2),j=1,mxata) /
     & 7,49,8,51,10,53,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,6),i=1,2),j=1,mxatha) /
     & 13,50,14,50,16,52,17,52,18,52,22,54,23,54,24,54,0,0/
c VAL
      data ((icca(i,j,7),i=1,2),j=1,mxata) /
     & 7,23,8,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,7),i=1,2),j=1,mxatha) /
     & 13,24,14,24,15,24,16,26,17,26,18,26,0,0,0,0,0,0/
c MET
      data ((icca(i,j,8),i=1,2),j=1,mxata) /
     & 6,266,12,269,36,268,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,8),i=1,2),j=1,mxatha) /
     & 10,267,11,267,28,270,29,270,30,270,0,0,0,0,0,0,0,0/
c ASP
      data ((icca(i,j,9),i=1,2),j=1,mxata) /
     & 6,218,29,219,30,219,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,9),i=1,2),j=1,mxatha) /
     & 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c ASN
      data ((icca(i,j,10),i=1,2),j=1,mxata) /
     & 6,228,29,229,21,230,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,10),i=1,2),j=1,mxatha) /
     & 25,231,26,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c LEU
      data ((icca(i,j,11),i=1,2),j=1,mxata) /
     & 6,35,10,37,11,39,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,11),i=1,2),j=1,mxatha) /
     & 10,36,22,38,23,38,24,38,25,40,26,40,27,40,0,0,0,0/
c LYS
      data ((icca(i,j,12),i=1,2),j=1,mxata) /
     & 6,279,9,281,12,283,27,285,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,12),i=1,2),j=1,mxatha) /
     & 10,280,11,280,19,282,20,282,28,284,29,284,
     & 40,286,41,286,42,286/
c GLU
      data ((icca(i,j,13),i=1,2),j=1,mxata) /
     & 6,240,9,242,34,243,35,243,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,13),i=1,2),j=1,mxatha) /
     & 10,241,11,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c GLN
      data ((icca(i,j,14),i=1,2),j=1,mxata) /
     & 6,252,9,254,34,255,24,256,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,14),i=1,2),j=1,mxatha) /
     & 10,253,11,253,34,257,35,257,0,0,0,0,0,0,0,0,0,0/
c PRO
      data ((icca(i,j,15),i=1,2),j=1,mxata) /
     & 6,103,9,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,15),i=1,2),j=1,mxatha) /
     & 10,104,11,104,13,104,16,104,19,106,20,106,22,106,25,106,0,0/
c ARG
      data ((icca(i,j,16),i=1,2),j=1,mxata) /
     & 6,295,9,297,17,301,22,299,25,302,26,302,0,0,0,0,0,0/
      data ((ihha(i,j,16),i=1,2),j=1,mxatha) /
     & 10,296,11,296,19,298,20,298,28,300,
     & 55,303,56,303,58,303,59,303/
c HIS (+, HIP)
      data ((icca(i,j,17),i=1,2),j=1,mxata) /
     & 6,169,11,172,13,174,20,170,24,176,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,17),i=1,2),j=1,mxatha) /
     & 22,171,25,173,31,175,34,177,0,0,0,0,0,0,0,0,0,0/
c PHE
      data ((icca(i,j,18),i=1,2),j=1,mxata) /
     & 6,115,10,116,11,116,13,118,14,118,17,120,0,0,0,0,0,0/
      data ((ihha(i,j,18),i=1,2),j=1,mxatha) /
     & 22,117,25,117,31,119,34,119,40,121,0,0,0,0,0,0,0,0/
c TYR
      data ((icca(i,j,19),i=1,2),j=1,mxata) /
     & 6,130,10,131,11,131,13,133,14,133,17,135,33,136,0,0,0,0/
      data ((ihha(i,j,19),i=1,2),j=1,mxatha) /
     & 22,132,25,132,31,134,34,134,52,137,0,0,0,0,0,0,0,0/
c TRP
      data ((icca(i,j,20),i=1,2),j=1,mxata) /
     & 6,146,10,147,11,149,14,152,15,153,16,159,
     & 18,155,19,157,23,150/
      data ((ihha(i,j,20),i=1,2),j=1,mxatha) /
     & 22,148,31,151,37,154,46,156,49,158,58,160,0,0,0,0,0,0/
c CYS -SS-
      data ((icca(i,j,21),i=1,2),j=1,mxata) /
     & 37,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,21),i=1,2),j=1,mxatha) /
     & 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
c HISD
      data ((icca(i,j,22),i=1,2),j=1,mxata) /
     & 6,186,11,189,13,191,20,187,24,193,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,22),i=1,2),j=1,mxatha) /
     & 22,188,25,190,31,192,0,0,0,0,0,0,0,0,0,0,0,0/
c HISE
      data ((icca(i,j,23),i=1,2),j=1,mxata) /
     & 6,202,11,204,13,206,20,203,24,208,0,0,0,0,0,0,0,0/
      data ((ihha(i,j,23),i=1,2),j=1,mxatha) /
     & 25,205,31,207,34,209,0,0,0,0,0,0,0,0,0,0,0,0/

      esc    = char(27)
      etx    = char(3)
      lf     = char(10)
      cr     = char(13)
      eot    = char(4)
      fs     = char(28)
      gs     = char(29)
      ff     = char(12)
      us     = char(31)

      nsol = 20
      mxnat = numat1
      igffrm = 1
      iixyz = 0
      iwropt = 0
      tokcal = 627.5095d0
      toang  = 0.52917706d0
      idebug = 0
      istiff = 0
      ncalf = 0
      ihashb = -1

      fdum = 1.0

      do i=1,mxel
         vrad(i) = vrad(i) / toang
      end do

      ihtype = 1
      vrad(100) = .0d0
      mxzat = maxat

      hdmin = 1.50d0/toang
      hdmax = 3.15d0/toang
      hamin = 145.0e0
      hamax = 215.0e0

      istdbd = 0
      idebug = 0
      natoms = 0

      nxtmf = 0
      ioadd = 0
      nstrt = 1

      iun1 = 5
      iun2 = 30
      iun3 = 6
      iun4 = 15
      iun5 = 77
      doinp = 0

      call parptr(6,fdum,fdum,iun1)
      call parptr(7,coo,fdum,idum)
      call parptr(8,vdwr,fdum,idum)
      call parptr(15,fdum,fdum,iatoms)
      call parptr(41,fdum,fdum,jring)
      call parptr(47,qat,fdum,idum)
      call parptr(48,fdum,fdum,iff)
      call parptr(49,fdum,fdum,ityp)
      call parptr(50,fdum,fdum,ipdbt)
      call parptr(51,fdum,fdum,istiff)
      call parptr(65,fdum,fdum,ipdbon)
      call parptr(142,xyz,fdum,idum)
      call parptr(149,fdum,fdum,isurf)
      call parptr(158,fdum,fdum,mxnat)
      call parptr(159,fdum,fdum,lwrit)
      call parptr(160,fdum,fdum,lring)
      call parptr(161,fdum,fdum,inat)
      call parptr(181,fdum,fdum,nmols)
      call parptr(191,fdum,fdum,ihashz)
      call parptr(209,fdum,fdum,iener)
      call parptr(210,ambchg,fdum,idum)

      call parstr(tmpfil,13)
      call parstr(moldroot,14)

      do i=1,mxmol2
         call parsfn(mol2(i),5,6)
      end do
      do i=1,mxamb
         call parsfn(ambstr(i),20,8)
      end do
      do i=1,numcal
         call parsfn(achain(i),1,11)
      end do
      do i=1,mxgff
         call parsfn(gffext(i),28,19)
      end do

      doinp = getinp()

      if (doinp.eq.1) then
         call parseopt()
      else
         call proarg
      endif

      call pdbstd(istat,0)

      call xyzcoo(0,1,0)

      call calfa(istat,1,1)

      call dotyp

      call dodck

      end

      subroutine getpdd(ires,ipdb,ihpdb,
     &                  ianz,iresid,ipdbt)
      implicit double precision (a-h,o-z)
      common /athlp/ iatoms, mxnat

      parameter (mxsym=103)
      parameter (mxhsym=64)
      dimension ipdb(mxsym),ihpdb(mxhsym*3)
      dimension ianz(*),iresid(*),ipdbt(*)

      do i=1,mxsym
          ipdb(i) = 0
      end do
      do i=1,mxhsym*3
          ihpdb(i) = 0
      end do

      do i=1,iatoms
          if (iresid(i).eq.ires) then
              if (ipdbt(i).ne.0) then
                  if (ianz(i).eq.1) then
                     ihpdb(ipdbt(i)) = i
                  else
                     ipdb(ipdbt(i)) = i
                  endif
              endif
          endif
      end do

      return
      end

      subroutine intcod(intc,rout,isel,inum,coo)
      implicit double precision (a-h,o-z)
      parameter (small=1.0d-5)
      common /athlp/ iatoms, mxnat
      real rout
      dimension v1(3),v2(3),v3(3),c12(3),c23(3),isel(4),coo(3,*)

      intc = 1

      todeg = 45.0d0 / datan(1.0d0)

      do i=1,3
          v1(i) = coo(i,isel(1)) - coo(i,isel(2))
          if (inum.ge.3) v2(i) = coo(i,isel(3)) - coo(i,isel(2))
          if (inum.ge.4) v3(i) = coo(i,isel(4)) - coo(i,isel(3))
      end do

      if (inum.eq.2) then
          rout = vlen(v1)
      endif

      if (inum.eq.3) then
          call impsc(v1,v2,cosb)
          if (cosb.gt.1.0d0) cosb = 1.0d0
          if (cosb.lt.-1.0d0) cosb = -1.0d0
          rout = dacos(cosb)*todeg
      endif

      if (inum.eq.4) then

          rout = 0.0

          do i=1,4
             if (isel(i).lt.1.or.isel(i).gt.iatoms) goto 100
             do j=i+1,4
                if (isel(i).eq.isel(j)) goto 100
             end do
          end do

          call crprod(v1,v2,c12)

          do i=1,3
             v2(i) = -v2(i)
          end do

          call crprod(v2,v3,c23)
          if (vlen(c12).eq.0.0d0.or.vlen(c23).eq.0.0d0) goto 100

          call impsc(c12,c23,cosb)
          call crprod(c12,c23,v1)

          if (vlen(v1) .lt. small ) then
              dihsgn = 1.0d0
          else
              call impsc(v1,v2,dihsgn)
              if (dihsgn.ge.0.0d0) then
                 dihsgn = -1.0d0
              else
                 dihsgn = 1.0d0
              endif
          endif

          if (cosb.gt.1.0d0) cosb = 1.0d0
          if (cosb.lt.-1.0d0) cosb = -1.0d0
          rout = dacos(cosb)*todeg*dihsgn
      endif

      return

100   intc = 0
      return
      end

      subroutine readel(line,n)
      character*(*) line
      character*137 lstr
      common /rdwr/ iun1,iun2,iun3,iun4,iun5

      do i=1,n
        read(iun2,'(a)',err=100,end=100) lstr
      end do
      line(1:137) = lstr(1:137)
      return
100   print*,"Premature end of file !"
      end 

      subroutine rewmd(molin)
      implicit double precision (a-h,o-z)
      common /mfdata/ nmols,imol,iendmf,ielin,maxmol,mollin
      common /mflin/ linmf
      common /rdwr/ iun1,iun2,iun3,iun4,iun5
      character*137 line
      dimension molin(*)

      call rewfil
      linmf = 0

      imol2 = imol
      if (imol.eq.0) imol2=1
      
      do i=1,molin(imol2)
          call nxtlin(line,jstat)
          if (jstat.eq.1) goto 100
          if (jstat.eq.2) goto 200

          linmf = linmf + 1
      end do
      call bckfil
      linmf = linmf - 1

      if (imol.ge.nmols) then
         iendmf = ielin
      else
         iendmf = molin(imol+1)
      endif

      return

100   continue
200   continue
      print*,'error rewind mf'
      return

      end 

      subroutine rwfile()
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      common /rdwr/   iun1,iun2,iun3,iun4,iun5

      rewind iun2

      return
      end

      integer function nxtwrd(string,strlen,itype,rtype)
c
c      string           nxtwrd = 1 
c      integer          nxtwrd = 2 
c      real             nxtwrd = 3 
c      no word          nxtwrd = 0
c
      character*(*) string
      integer itype,strlen,ilen,iend
      double precision rtype
      double precision reada
      logical chkstr
      character*137 line
      common /curlin/ line

      nxtwrd = 0
      
      ilen = 0
      llen = linlen(line)
      if (ilen.gt.len(line)) then
          ilen = len(line)
      endif
      if (llen.eq.0) return

      do while (line(1:1).eq.' ')
          line = line(2:)
      end do

      iend = index(line,' ')
      if (iend.eq.0) then
         iend = llen
      else
         iend = iend - 1
      endif
      if (chkstr(line,iend)) then
           nxtwrd = 1
           string = line(1:iend)
           strlen = iend
      elseif (index(line(1:iend),'.').ne.0) then
           nxtwrd = 3
           rtype = reada(line,1,iend)
      else
           nxtwrd = 2
           itype = reada(line,1,iend)
      endif

      line = line(iend+1:)

      return
      end

      double precision function reada(a,istart,ll)
      implicit double precision (a-h,o-z)
      character*1 a(ll)
      logical multi,scient

      nine  = ichar('9')
      izero = ichar('0')
      minus = ichar('-')
      iplus = ichar('+')
      idot  = ichar('.')
      ie    = ichar('E')
      iee   = ichar('e')
      id    = ichar('D')
      idd   = ichar('d')
      idig  = 0
      k1    = 0
      k2    = 0
      k3    = 0
      one   = 1.d0
      x     = 1.d0
      do j=istart,ll
         n = ichar(a(j))
         if((n.le.nine.and.n.ge.izero).or. n.eq.minus.or.n.eq.idot)
     &   goto 7
      end do
      reada = 0.d0
      return

7     continue
c     before the dot
      do i=j,ll
         n = ichar(a(i))
         if (n.le.nine.and.n.ge.izero) then
            idig = idig + 1
            if (idig.gt.10) then
               ii = i
               goto 90
            endif
            k1 = k1*10 + n - izero
         elseif (n.eq.minus.and.i.eq.j) then
             one = -1.d0
         elseif (n.eq.idot) then
             goto 30
         else
             ii = i
             goto 90
         endif
      end do
30    continue
c     after the dot
      idig = 0
      do ii=i+1,ll
         n = ichar(a(ii))
         if (n.le.nine.and.n.ge.izero) then
            idig = idig + 1
            if (idig.gt.9) goto 90
            k2 = k2*10 + n - izero
            x = x /10
         elseif (n.eq.minus.and.ii.eq.i) then
            x = -x
         else
            goto 90
         endif
      end do
90    continue
      scient = .false.
      do jj=ii,ll
         n = ichar(a(jj))
         if (n.eq.ie.or.n.eq.iee.or.n.eq.id.or.n.eq.idd) goto 95
      end do
      goto 100
95    continue
         if (jj.lt.159) then
            scient = .true.
            n = ichar(a(jj+1))
            if (n.eq.minus.or.n.eq.iplus) then
                multi = .true.
                if (n.eq.minus) multi = .false.
                idig = 0
                do j=jj+2,ll
                   n = ichar(a(j))
                   if (n.le.nine.and.n.ge.izero) then
                       idig = idig + 1
                       if (idig.gt.9) goto 90
                       k3 = k3*10 + n - izero
                   else
                      goto 100
                   endif
                end do
            endif
         endif

100   continue
      reada = one * ( k1 + k2 * x)
      if (scient) then
          if (multi) then
              reada = reada * 10**k3
          else
              if (k3.gt.25) then
                 reada = 0.0d0
              else
                 reada = reada / 10**k3
              endif
          endif
      endif

      return
      end

      logical function chkstr(line,iend)
      integer ie,iee,id,idd,nine,izero,minus
      integer iplus,idot,icomma,islash
      character*(*) line
      chkstr = .false.

      ie    = ichar('e')
      iee   = ichar('E')
      id    = ichar('d')
      idd   = ichar('D')
      nine  = ichar('9')
      izero = ichar('0')
      minus = ichar('-')
      iplus = ichar('+')
      idot  = ichar('.')
      icomma = ichar(',')
      islash  = ichar('/')

      ihase = 0
      idig = 0
      do i=1,iend
         n = ichar(line(i:i))
         if ((n.eq.ie.or.n.eq.iee.or.n.eq.id.or.n.eq.idd)
     &      .and.ihase.eq.0.and.idig.eq.1) then
             n = izero
             ihase = 1
         endif
         if (n.ne.0) then
            if (n.lt.iplus.or.n.gt.nine.or.n.eq.islash
     &          .or.n.eq.icomma) goto 100
            idig = 1
         endif
      end do

      n = ichar(line(1:1))
      n2 = ichar(line(2:2))
      if (iend.eq.1) then
         if (n.eq.minus) goto 100
         if (n.eq.iplus) goto 100
         if (n.eq.ie.or.n.eq.iee) goto 100
         if (n.eq.id.or.n.eq.idd) goto 100
      elseif (iend.gt.1) then
         if (n.eq.minus.and.n2.eq.minus) goto 100
      endif

      return
100   chkstr = .true.
      return
      end

      subroutine filclo(iun)
      implicit double precision (a-h,o-z)

      close(iun)

      return
      end

      integer function linlen(line)
      character*(*) line
      integer i,n

      linlen = 0

      do i=len(line),1,-1
         n = ichar(line(i:i))
         if (n.gt.32.and.n.le.126) goto 100
      end do

      return
100   linlen = i
      return
      end

      subroutine tomold(rout,isel,inum)
      implicit double precision (a-h,o-z)
      real rout
      common /rdwr/  iun1,iun2,iun3,iun4,iun5
      dimension isel(4)

      call intcor(intc,rout,isel,inum)
      if (intc.eq.0) then
          write(iun3,*) 'Error calculating internal coordinate'
      endif

      return
      end

      subroutine crprod(a,b,c)
c
c       calculates cross product:   a x b = c
c                                   -   -   -
      implicit double precision (a-h,o-z)
      dimension a(3),b(3),c(3)
 
      c(1) = a(2)*b(3) - a(3)*b(2)
      c(2) = a(3)*b(1) - a(1)*b(3)
      c(3) = a(1)*b(2) - a(2)*b(1)

      return
      end

      double precision function vlen(a)
      implicit double precision (a-h,o-z)
      dimension a(3)

      tot = a(1)*a(1)+a(2)*a(2)+a(3)*a(3)
      vlen = 0.0d0
      if (tot.gt.0.0d0) vlen = dsqrt(tot)

      return
      end

      subroutine setatms(iato)
      implicit double precision (a-h,o-z), integer (i-n)
      common /athlp/ iatoms, mxnat

      iatoms = iato

      return
      end

      subroutine calgad(iasel,iprnt,istat,qat,ianz,iconn,iresid,ityp)
      implicit double precision(a-h,o-z)
      parameter (numat1=20000)
      parameter (mxcon=10)
      parameter (mxsigm=16)
      parameter (mxmol2=41)
      common /sigma/ siga(mxsigm),sigb(mxsigm),sigc(mxsigm),
     &               sigd(mxsigm),impmol2(mxmol2)
      common /athlp/ iatoms, mxnat
      common /charge/ ihasq
      common /types/ iff
      dimension zz(numat1)
      dimension qat(*),ianz(*),iconn(mxcon+1,*),ityp(*),iresid(*)

      call sigini
  
      ihasq = 0
      istat = 0
      iff = 5

      call dotyp(0)
  
      do i=1,iatoms
         if (iasel.gt.0.or.(iasel.lt.-3.and.iasel.eq.iresid(i)) )
     &   then

            it = ityp(i)

            if (it.gt.0.and.it.le.mxmol2) then
                l = impmol2(it)
            else
                print*,'Gasteiger: Untyped mol2 atom type.'
                istat = 1
                return
            endif

            if (i.le.numat1) then
                zz(i) = siga(l)
            else
                print*,'array for gasteiger calculation to small'
                istat = 1
                return
            endif

            qat(i) = 0.0d0
            ia = ianz(i)

            if (ia.eq.6) then

              if (ityp(i).eq.9) qat(i) = 1.0d0

            elseif (ia.eq.7) then

              ibnd = 0
              do j=1,iconn(1,i)
                 if (iconn(1+j,i).gt.0) ibnd = ibnd + 1
              end do
              if (ibnd.eq.4) qat(i) = 1.0d0

c              if (N3+) qat(i) = 1.0d0

            elseif (ia.eq.8) then
c carboxyl
              if (ityp(i).eq.19) qat(i) = -0.5d0

            endif
         endif
      end do

      fac = 1.0d0
      icnt = 0

      do while (.true.)

          fac = fac*0.5d0
          sd1 = 0.0d0

          do i=1,iatoms

           if (iasel.gt.0.or.(iasel.lt.-3.and.iasel.eq.iresid(i)) )
     &     then

             l = impmol2(ityp(i))

             if (sigd(l).ne.1.0d0) then

                qt = qat(i)
                do j=1,iconn(1,i)
                   if (iconn(1+j,i).gt.0) then
                      jj = iabs(iconn(1+j,i))
                      ll = impmol2(ityp(jj))
                      if (sigd(ll).ne.1.0d0) then
                         sd2 = sigd(ll)
                         if (i.le.numat1.and.jj.le.numat1) then
                            if (zz(jj).gt.zz(i)) sd2 = sigd(l)
                         endif
                         if (ianz(i).eq.1.or.ianz(jj).eq.1) 
     &                      sd2 = 20.02d0
                         if (i.le.numat1.and.jj.le.numat1) then
                            qat(i) = qat(i) + (zz(jj) - zz(i))*fac/sd2
                         endif
                      endif
                   endif
                end do

                qt = dabs(qat(i) - qt)
                if (qt.gt.sd1) sd1 = qt

             endif

           endif
          end do

          if (sd1.ge.1.0d-3) then

             do i=1,iatoms

              if (iasel.gt.0.or.(iasel.lt.-3.and.iasel.eq.iresid(i)) )
     &        then
                l = impmol2(ityp(i))
                zz(i) = siga(l) + sigb(l)*qat(i) + sigc(l)*qat(i)*qat(i)
              endif

             end do

          endif 

          icnt = icnt + 1

          if (.not.(sd1.gt.1.0d-3.and.icnt.le.5)) goto 100
      end do

100   continue

      if (iprnt.eq.1) then
         write (*,'(a)') ' '
         write (*,'(a)') 'Gasteiger charges'
         write (*,'(a)') ' '
      endif

      qtot = 0.0d0

      do i=1,iatoms
        if (ianz(i).ne.100) then
          if (iasel.gt.0.or.(iasel.lt.-3.and.iasel.eq.iresid(i)) )
     &    then
             qtot = qtot + qat(i)
             if (iprnt.eq.1) 
     &            write (*,'(i5,1x,i3,1x,f10.5)') i,ianz(i),qat(i)
          endif
        endif
      end do

      if (iprnt.eq.1) then
        write (*,'(a)') ' '
        write (*,'(a,f10.3)') 'Sum of Gasteiger charges = ',qtot
      endif

      ihasq = 1
      return
      end

      subroutine sigini
      implicit double precision(a-h,o-z)
      parameter (mxsigm=16)
      parameter (mxmol2=41)
      common /sigma/ siga(mxsigm),sigb(mxsigm),sigc(mxsigm),
     &               sigd(mxsigm),impmol2(mxmol2)
      data siga /7.17,7.98,8.79,10.39,11.54,12.87,15.68,14.18,
     &       17.07,14.66, 11.00, 10.08,9.90,10.14,8.9,0.0/
      data sigb /6.24,9.18,9.32,9.45,10.82,11.15,11.70,12.92,
     &           13.79,13.85,9.69,8.47,7.96,9.13,8.24,0.0/
      data sigc /-0.56,1.88,1.51,0.73,1.36,0.85,-0.27,1.39,
     &           0.47,2.31,1.35,1.16,0.96,1.38,0.96,0.0/
      data impmol2 /16,16,16,16,2,3,4,3,3,5,6,7,6,6,6,5,
     &           8,9,9,8,8,14,14,14,14,15,1,1,1,10,11,12,13,
     &           16,16,16,16,16,16,16,16/

c sybyl atom types to gasteiger types
c1 any
c2 hal
c3 het
c4 hev
c5 C.3     2
c6 C.2     3
c7 C.1     4
c8 C.ar    3
c9 C.cat   ?
c10 N.3    5
c11 N.2    6
c12 N.1    7
c13 N.ar   6
c14 N.am   6
c15 N.pl3  6
c16 N.4    5
c17 O.3    8
c18 O.2    9
c19 O.co2  9
c20 O.spc  8
c21 O.t3p  8
c22 S.3    14
c23 S.2    14
c24 S.O    14
c25 S.O2   14
c26 P.3    15
c27 H      1
c28 H.spc  1
c29 H.t3p  1
c30 F      10
c31 Cl     11
c32 Br     12
c33 I      13
c34 Si
c35 Lp
c36 Du
c37 Na
c38 K
c39 Ca
c40 Li
c41 Al

c unknown is DU 16

      do i=1,mxsigm
         sigd(i) = siga(i) + sigb(i) + sigc(i)
      end do
      sigd(15) = 1.0d0

      return
      end
                              
      subroutine ringd(i,iring,nring,iflat,ianz,iaton,iconn,
     &                 lwrit,lring,iret)
      implicit double precision (a-h,o-z)
      parameter (mxcon=10)
      logical oflat,ringg
      dimension iring(6),ianz(*),iaton(*),iconn(mxcon+1,*)
      dimension lwrit(*),lring(*)

c print is to prevent segment violation on MacOSX gfortran
c apple-darwin15. Uncomment next line
c newer versions of grfortran may not have this bug
c      print*," "
      if (iflat.gt.0) then
          oflat = .true.
      else 
          oflat = .false.
      endif

      iret = 0

      if (ringg(i,iring,nring,oflat,ianz,iaton,iconn,lwrit,lring)) then
         iret = 1
      endif

      return
      end

      logical function ringg(i,iring,nring,oflat,ianz,iaton,iconn,
     &                       lwrit,lring)
      implicit double precision (a-h,o-z)
      parameter (mxcon=10)
      logical ocnos,oring,oflat,do4b,do5,do5b,do6,do6b
      logical do4bf,do5bf,do6f,do6bf
      real dihed
      dimension isel(4),iring(6),ianz(*),iaton(*),iconn(mxcon+1,*)
      dimension lwrit(*),lring(*)
      
c oflat finds flat 6,5 membered rings
  
      ringg = .true.
      do4b = .false.
      do5  = .false.
      do5b = .false.
      do6  = .false.
      do6b = .false.

      do4bf = .false.
      do5bf = .false.
      do6f  = .false.
      do6bf = .false.

      nring = -1 

      if (ocnos(i,ianz,iaton)) then
         do j=1,iconn(1,i)
            jj = abs(iconn(j+1,i))
            if (ocnos(jj,ianz,iaton)) then
               do k=1,iconn(1,jj)
                  kk = abs(iconn(k+1,jj))
                  if (ocnos(kk,ianz,iaton).and.kk.ne.i) then
                     do l=1,iconn(1,kk)
                        ll = abs(iconn(l+1,kk))
                        if (ocnos(ll,ianz,iaton).and.ll.ne.jj
     &                      .and.ll.ne.i) then
                           isel(1) = i
                           isel(2) = jj
                           isel(3) = kk
                           isel(4) = ll
                           call intcor(intc,dihed,isel,4)
                           if (intc.eq.0) then
                              call haszm(.false.)
                              ringg = .false.
                              do4bf = .true.
                              return
                           else
                              do4b = .true.
                           endif
                           if ((.not.oflat.and.abs(dihed).lt.90.0e0)
     &                        .or.(oflat.and.abs(dihed).lt.5.0e0)) then
                              do m=1,iconn(1,i)
                                 mm = abs(iconn(m+1,i))
                                 if (ocnos(mm,ianz,iaton).and.mm.ne.jj) 
     &                           then
                                    do n=1,iconn(1,ll)
                                       nn = abs(iconn(n+1,ll))
                                       if (ocnos(nn,ianz,iaton).and.
     &                                           nn.ne.kk) then
                                          if (mm.eq.nn) then
                                             nring = 5
                                             iring(1) = i
                                             iring(2) = jj
                                             iring(3) = kk
                                             iring(4) = ll
                                             iring(5) = mm
                                             if (oflat) then
                                                call intcor(intc,dihed,
     &                                          iring(2),4)
                                                if (intc.eq.0) then
                                                   call haszm(.false.)
                                                   ringg = .false.
                                                   do5bf = .true.
                                                   return
                                                else
                                                   do5b = .true.
                                                endif
                                             endif
                                             if (.not.oflat.or.(oflat
     &                                       .and.abs(dihed).lt.5.0e0))
     &                                       then
                                                if (oring(nring,iring,
     &                                              lwrit,lring)) then
                                                 return
                                                endif
                                             endif
                                          else
                                          do ii=1,iconn(1,nn)
                                             ij=abs(iconn(ii+1,nn))
                                             if (ocnos(ij,ianz,iaton)
     &                                           .and.ij.ne.ll)
     &                                       then
                                               if (ij.eq.mm.and.i.ne.nn) 
     &                                         then
                                                   nring = 6
                                                   iring(1) = i
                                                   iring(2) = jj
                                                   iring(3) = kk
                                                   iring(4) = ll
                                                   iring(5) = nn
                                                   iring(6) = ij

                                             if (oflat) then
                                                call intcor(intc,dihed,
     &                                                      iring(3),4)
                                                if (intc.eq.0) then
                                                    call haszm(.false.)
                                                    ringg = .false.
                                                    do6f = .true.
                                                    return
                                                else
                                                    do6 = .true.
                                                endif
                                             endif

                                             if (.not.oflat.or.(oflat
     &                                       .and.abs(dihed).lt.5.0e0))
     &                                       then
                                                if (oring(nring,iring,
     &                                              lwrit,lring)) then
                                                  do6bf = .true.
                                                  return
                                                else
                                                  do6b = .true.
                                                endif
                                             endif
                                               endif
                                             endif
                                          end do
                                          endif
                                       endif
                                    end do
                                 endif
                              end do
                           endif
                        endif
                     end do
                  endif
               end do
            endif
         end do
      endif


      if (nring.gt.0) then
         ringg = .true.
      else
         nring = 0
         ringg = .false.
      endif

      return
      end

      logical function ocnos(inum,ianz,iaton)
      implicit double precision (a-h,o-z)
      dimension ianz(*),iaton(*)
      
      ocnos = .false.
      iatnr = ianz(inum)
      if ((iatnr.eq.6.or.iatnr.eq.7.or.iatnr.eq.8.or.iatnr.eq.16)
     &    .and.iaton(inum).eq.2) ocnos = .true.

      return
      end

      logical function oring(nring,iring,lwrit,lring)
      implicit double precision (a-h,o-z)
      dimension iring(6),lwrit(*),lring(*)

      oring = .false.
      itot = 0
      jtot = 0
      do i=1,nring
        itot = itot + lring(iring(i)) 
        if (lwrit(iring(i)).ne.0) jtot = jtot + 1
      end do
c      print*,"itot ",itot," jtot ",jtot," nring ",nring
      if (itot.le.nring.and.jtot.le.nring) oring = .true.

      return
      end

      subroutine haszm(zmok)
      implicit double precision (a-h,o-z)
      common /zmfrst/ ihaszm, nz, mxzat
      logical zmok

      ihaszm = 0
      nz = 0
      
      return
      end

      integer function icdex(line,name)
      character*(*) line,name
      character*80 caps
      character*137 cline

      il1 = len(line)
      if (il1.gt.137) il1 = 137
      il2 = len(name)
      if (il2.gt.80) il2 = 80

      cline(1:il1) = line
      caps(1:il2) = name
      call tocap(cline,il1)
      call tocap(caps,il2)

      icdex = index(cline(1:il1),caps(1:il2))

      return
      end

      subroutine nxline(line,istat)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      character*137 line
      common /rdwr/   iun1,iun2,iun3,iun4,iun5

      istat = 0

      read(iun2,'(a)',end=100,err=200) line

c      print*,"==",line,"=="
      return
100   istat = 1
      return
200   istat = 2
      return
      end

      integer function icred(iat,inoh,ih,ianz,iconn)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxcon=10)
      dimension iconn(mxcon+1,*),ianz(*)

      icred = 0
      if (iat.le.0) return

      inoh = 0
      ih = 0
      do j=1,iconn(1,iat)
         jat = iconn(j+1,iat)
         if (jat.gt.0) then
            icred = icred + 1
            if (ianz(jat).eq.1) then
               ih = ih + 1
            else
               inoh = inoh + 1
            endif
         endif
      end do

      return
      end

      integer function ibtyp(iat,jat,idochg,ifive,ianz)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxt=14)
      character*4 atype
      common /atypes/ ihbt(mxt),atype(mxt)
      dimension ianz(*)

      call ispn(irs,iat,irng,idochg,ifive)
      ihb1 = ihbt(irs)
      call ispn(irs,jat,irng,idochg,ifive)
      ihb2 = ihbt(irs)
      ibtyp = 1
      if (ihb1.eq.2.and.ihb2.eq.2) ibtyp = 2
      if (ihb1.eq.1.and.ihb2.eq.1) ibtyp = 3
      if (ihb1.eq.4.and.ihb2.eq.4) ibtyp = 4
      if ((ihb1.eq.4.and.ihb2.eq.2).or.(ihb1.eq.2.and.ihb2.eq.4)) 
     &   ibtyp = 2
      if (ihb1.eq.3.and.ianz(iat).eq.15
     &    .and.ihb2.eq.2.and.ianz(jat).eq.8) ibtyp = 2
      if (ihb2.eq.3.and.ianz(jat).eq.15
     &    .and.ihb1.eq.2.and.ianz(iat).eq.8) ibtyp = 2

      return
      end

      subroutine outmod(iun,coo,ianz,iconn)
      implicit double precision (a-h,o-z), integer ( i-n)
      parameter (mxcon=10)
      parameter (maxsym=108)
      parameter (mxel=100)
      character*2 elemnt,tocapf
      character*3 atom,atomt
      common /athlp/  iatoms, mxnat
      common /elem/   elemnt(mxel)
      character*137 line
      common /curlin/ line
      common /rdwr/   iun1,iun2,iun3,iun4,iun5
      dimension coo(3,*),ianz(*),iconn(mxcon+1,*)
      dimension vec1(3),vec2(3)

      toang = 0.52917706d0
      natoms = iatoms
      nbnds = 0
      idochg = 0

      do i=1,natoms
         do j=1,iconn(1,i)
            if (iconn(1+j,i).gt.0) then
               if (iconn(1+j,i).gt.i) nbnds = nbnds + 1
            endif
         end do
      end do

      write(iun,'(a)') ' '
      write(iun,'(a)') '  -MOLDEN-'
      write(iun,'(a)') 'Molden generated mol file'
      write(iun,'(i3,i3,a)') natoms,nbnds,
     &          '  0  0  0  0  0  0  0  0999 V2000'

      do i=1,natoms
         atomt = '   '
         atomt(1:2) = tocapf(elemnt(ianz(i)))
         call leftj(atomt,atom)
         write(iun,'(3f10.4,a1,a3,a)') (coo(j,i)*toang,j=1,3),' ',
     &      atom, ' 0  0  0  0  0  0  0  0  0  0  0  0'
      end do
    
      do i=1,natoms
         do j=1,iconn(1,i)
            k = iconn(1+j,i)
            if (k.gt.0) then
               if (k.gt.i) then
                  ibt = ibtyp(i,k,idochg,0,ianz)
                  call inpland(i,k,inp1,vec1,coo,iconn,ianz)
                  call inpland(k,i,inp2,vec2,coo,iconn,ianz)
                  if (ibt.eq.2.and.
     &                (inp1.eq.0.or.inp2.eq.0)) ibt = 1
                  if (ibt.eq.2.and.
     &                (inp1.eq.1.and.inp2.eq.1)) then
                      rimp = 0.0
                      do ii=1,3
                         rimp = rimp + vec1(ii)*vec2(ii)
                      end do
                      if ((1.0 - dabs(rimp)).gt.0.1) ibt = 1
                  endif
                  write(iun,'(3i3,a)') i,k,ibt,
     &               '  0  0  0  0'
               endif
            endif
         end do
      end do

      write(iun,'(a)') 'M  END'

      return
      end

      integer function getlin(ieq)
      character*137 line
      common /rdwr/   iun1,iun2,iun3,iun4,iun5
      common /curlin/ line
      common /mflin/  linmf

      getlin = 1

      line(1:1) = " "
      call nxtlin(line,jstat)
      if (jstat.eq.1.or.jstat.eq.2) goto 100

      linmf = linmf + 1
      do i=1,137
         if (ichar(line(i:i)).eq.9) line(i:i) = ' '
      end do

      if (ieq.eq.1.or.ieq.eq.2) then
         do i=1,137
            if (ichar(line(i:i)).eq.61) line(i:i) = ' '
         end do
      endif

      if (ieq.eq.2) then
         do i=1,137
            ii = ichar(line(i:i))
            if (ii.eq.40.or.ii.eq.41.or.ii.eq.34.or.ii.eq.39) 
     &         line(i:i) = ' '
         end do
      endif

      if (ieq.eq.3) then
         do while (.true.)
            i1 = index(line,'(')
            i2 = index(line,')')
            if (i1.gt.0.and.i2.gt.0) then
               line = line(1:i1-1)//line(i2+1:)
            else
               return
            endif
         end do
      endif

      return

100   getlin = 0
      return
      end

      character*2 function tolowf(line)
      character*2 line

      tolowf = line

      do i=1,2
         j = ichar(tolowf(i:i))
         if (j.ge.65.and.j.le.90) tolowf(i:i) = char(j+32)
      end do

      return
      end

      subroutine leftj(line,name)
      character*(*) line,name

      name = line
      len1  = len(line)

      nsp = 0
      do i=1,len1
         if (ichar(name(i:i)).ne.32) then
            nsp = i
            goto 10
         endif
      end do

10    continue

      if (nsp.ne.0) then
         name = name(nsp:len1)
      endif

      return
      end

      subroutine inpland(iat,jat,inpl,vout,coo,iconn,ianz)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxcon=10)
      common /athlp/ iatoms, mxnat
      dimension coo(3,*),iconn(mxcon+1,*),vec1(3),vec2(3),vec3(3),d(3)
      dimension vout(3),ianz(*)

      inpl = 0

      n = iconn(1,iat)
      ia = ianz(iat)
      if (ia.eq.6.and.n.ne.3) return
      if (ia.eq.8.and.n.ne.1) return
      if (ia.eq.7.and.n.eq.1) return
      if (ia.eq.16.and.(n.ne.2.or.n.ne.4)) return
      
      if (ia.ne.6.and.ia.ne.7.and.ia.ne.8.and.ia.ne.16) return

      if (ia.eq.8.and.n.eq.1) then
         inpl = 1
         return
      endif

      if (ia.eq.7.and.n.eq.2) then
         inpl = 1
         return
      endif

      i1 = iconn(1+1,iat)
      i2 = iconn(1+2,iat)
      i3 = iconn(1+3,iat)

      if (i1.le.0.or.i1.gt.mxnat) return
      if (i2.le.0.or.i2.gt.mxnat) return
      if (i3.le.0.or.i3.gt.mxnat) return

      if (i1.eq.jat) then
         do j=1,3
            vec1(j) = coo(j,iat) - coo(j,i2)
            vec2(j) = coo(j,iat) - coo(j,i3)
            vec3(j) = coo(j,iat) - coo(j,jat)
         end do
      else if (i2.eq.jat) then
         do j=1,3
            vec1(j) = coo(j,iat) - coo(j,i1)
            vec2(j) = coo(j,iat) - coo(j,i3)
            vec3(j) = coo(j,iat) - coo(j,jat)
         end do
      else if (i3.eq.jat) then
         do j=1,3
            vec1(j) = coo(j,iat) - coo(j,i1)
            vec2(j) = coo(j,iat) - coo(j,i2)
            vec3(j) = coo(j,iat) - coo(j,jat)
         end do
      endif

      d(1) = vec2(2)*vec1(3) - vec2(3)*vec1(2)
      d(2) = vec2(3)*vec1(1) - vec2(1)*vec1(3)
      d(3) = vec2(1)*vec1(2) - vec2(2)*vec1(1)

      dlen = dsqrt(d(1)*d(1)+d(2)*d(2)+d(3)*d(3))
      vlen = dsqrt(vec3(1)*vec3(1)+vec3(2)*vec3(2)+vec3(3)*vec3(3))

      rimp = 0.0
      do i=1,3
         d(i) = d(i)/dlen
         vout(i) = d(i)
         vec3(i) = vec3(i)/vlen
         rimp = rimp + d(i)*vec3(i)
      end do

      if (dabs(rimp).lt.0.1) inpl = 1

      return
      end

      logical function ismet(ian)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mexcl=10)
      common /metexc/ qexcl(mexcl),ianexc(mexcl)

      ismet = .false.

      do i=1,mexcl
         if (ian.eq.ianexc(i)) ismet = .true.
      end do

      return
      end

      subroutine setid(nres,istart,isurf,iresid,ipdbt)
      implicit double precision (a-h,o-z), integer ( i-n)
      common /athlp/ iatoms, mxnat
      dimension isurf(*),iresid(*),ipdbt(*)

      do i=istart+1,mxnat
         isurf(i) = 0
         ipdbt(i) = 0
         iresid(i) = -nres
      end do

      return
      end

      subroutine getrng(iat,iout,ianz,iconn)
      implicit double precision (a-h,o-z)
      common /athlp/  iatoms, mxnat
      parameter (mxcon=10)
      dimension ianz(*),iconn(mxcon+1,*)
   
      iout = 0
      call ring5(nring,iat,ianz,iconn)

      if (nring.eq.5) iout = 1
   
      return
      end

      subroutine ring5(nring,iat,ianz,iconn)
      implicit double precision (a-h,o-z)
      parameter (mxcon=10)
      real dihed
      dimension isel(4),iring(6),ianz(*),iconn(mxcon+1,*)
      
c oflat finds flat 6,5 membered rings
  
      do i=1,6
         iring(i) = 0
      end do

      nring = 0
      ia = ianz(iat)
      if (ia.eq.6.or.ia.eq.7.or.ia.eq.8.or.ia.eq.16) then
         do j=1,iconn(1,iat)
            jj = abs(iconn(j+1,iat))
            ja = ianz(jj)
            if (ja.eq.6.or.ja.eq.7.or.ja.eq.8.or.ja.eq.16) then
               do k=1,iconn(1,jj)
                  kk = abs(iconn(k+1,jj))
                  ka = ianz(kk)
                  if ((ka.eq.6.or.ka.eq.7.or.ka.eq.8.or.ka.eq.16)
     &                 .and.kk.ne.iat) then
                     do l=1,iconn(1,kk)
                        ll = abs(iconn(l+1,kk))
                        la = ianz(ll)
                        if ((la.eq.6.or.la.eq.7.or.la.eq.8.or.la.eq.16)
     &                      .and.ll.ne.iat.and.ll.ne.jj) then
                           isel(1) = iat
                           isel(2) = jj
                           isel(3) = kk
                           isel(4) = ll
                           call intcor(intc,dihed,isel,4)
                           if (intc.eq.0) then
                              nring = 0
                              return
                           endif

                           if (abs(dihed).lt.5.0e0) then
                              do m=1,iconn(1,iat)
                                 mm = abs(iconn(m+1,iat))
                                 ma = ianz(mm)
                                 if ((ma.eq.6.or.ma.eq.7.or.ma.eq.8.or.
     &                                ma.eq.16).and.mm.ne.jj) then
                                    do n=1,iconn(1,ll)
                                       nn = abs(iconn(n+1,ll))
                                       na = ianz(nn)
                                       if ((na.eq.6.or.na.eq.7.or.
     &                                      na.eq.8.or.na.eq.16)
     &                                      .and.nn.ne.kk) then
                                          if (mm.eq.nn) then
                                             nring = 5
                                             iring(1) = iat
                                             iring(2) = jj
                                             iring(3) = kk
                                             iring(4) = ll
                                             iring(5) = mm
                                             call intcor(intc,dihed,
     &                                          iring(2),4)
                                             if (intc.eq.0) then
                                                nring = 0
                                                return
                                             endif

                                             if (abs(dihed).lt.5.0e0)
     &                                       then
                                                return
                                             endif

                                          endif
                                       endif
                                    end do
                                 endif
                              end do
                           endif
                        endif
                     end do
                  endif
               end do
            endif
         end do
      endif

      return
      end

      subroutine chkbrd(iconn,icalf,ianf,islu,iamino,isal,reson,
     &                  ncalf,nchain)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxcon=10)
      parameter (mxchai=50)
      integer reson
      dimension iconn(mxcon+1,*)
      dimension icalf(6,*),ianf(*),islu(*),iamino(*),reson(*),isal(*)

      nchain = 1
      ianf(1) = 1

      do i=1,ncalf-1
         inewch = 0
         if (iamino(i).le.23) then
            isami = 1
         else
            isami = 0
         endif

         if (iamino(i+1).le.23) then
            isnew = 1
         else
            isnew = 0
         endif

         if (isami.ne.isnew) then
            inewch = 1
         else
            ifnd = 0
            if (isami.eq.1) then
               ii = icalf(3,i)
               jj = icalf(2,i+1)
               if (ii.gt.0) then
                  do j=1,iconn(1,ii)
                     if (iconn(1+j,ii).eq.jj) ifnd = 1
                  end do
               endif
            else
               ii = icalf(6,i)                   
               jj = icalf(1,i+1)
               if (ii.gt.0) then
                  do j=1,iconn(1,ii)
                     if (iconn(1+j,ii).eq.jj) ifnd = 1
                  end do
               endif
            endif
            if (ifnd.eq.0) inewch = 1
         endif

         if (inewch.eq.1.and.nchain.lt.mxchai) then
            if (nchain.gt.0) islu(nchain) = i
            nchain = nchain + 1
            ianf(nchain) = i + 1
         endif

         reson(i) = 1
         isal(i) = 3
      end do

      reson(ncalf) = 1
      islu(nchain) = ncalf

      return
      end 

      subroutine xyzcod(idocopy,idoconv,ioadd,
     &                  ianz,coo)
      implicit double precision (a-h,o-z)
      parameter (numatm=2000)
      common /athlp/  iatoms, mxnat
      common /coord / xyz(3,numatm)
      common /moldat/ natoms, norbs, nelecs,nat(numatm)
      common /surf/   natorg,noscnd
      dimension coo(3,*),ianz(*)

      toang = 0.52917706d0

      if (idocopy.eq.1) iatoms = natoms

      noff = 1
      if (ioadd.eq.1) noff = natorg + 1

      do i=noff,iatoms
         if (idocopy.eq.1) ianz(i) = nat(i)
         do j=1,3
           if (idoconv.eq.1) then
              if (idocopy.eq.1) then
                 coo(j,i) = xyz(j,i) / toang
              else
                 coo(j,i) = coo(j,i) / toang
              endif
           else
              coo(j,i) = xyz(j,i)
           endif
         end do
      end do

      if (ioadd.eq.1) natorg = 0

      return
      end

      subroutine cooxyz(ianz,iatoms)
      implicit double precision (a-h,o-z)
      parameter (numatm=2000)
      common /moldat/ natoms, norbs, nelecs,nat(numatm)
      dimension ianz(*)
      
      natoms = iatoms
      if (natoms.gt.numatm) natoms = numatm

      do i=1,natoms
         nat(i) = ianz(i)
      end do

      return
      end

      subroutine prtflg
      implicit double precision (a-h,o-z)

      print*,'Docker1.0 (2022) Dr. G.Schaftenaar, Theochem'
      print*,'URL: http://www.theochem.ru.nl/molden/'
      print*,' '
      print*,'G. Schaftenaar,E. Vlieg,G. Vriend,'
      print*,'J.Comp.-Aided.Mol.Des.,31 (2017) 789'
      print*,' '
      print*,'G. Schaftenaar,J.H. Noordik,'
      print*,'J.Comp.-Aided.Mol.Des.,14 (2000) 123'
      print*,' '
      print*,'Usage: docker [ options ... ] pdb_file'
      print*,' '
      print*,'where options include:'
      print*,' '
      print*,'-r dock.xyz  filename of ligand containing '
      print*,'             file in ambfor .xyz format'
      print*,'-n 20        number of docking poses '
      print*,'-h 0         defining the docking site:'
      print*,'             number of the occurance of the'
      print*,'             HETATM residue in the pdb_file'
      print*,'-i ''string''  defining the docking site (alt.):'
      print*,'             ''string'' is the name of the HETATM '
      print*,'             residue in the pdb_file'
      print*,'-V 0         change the allowed deviation '
      print*,'             0 = 0.65 Angstrom (Default)'
      print*,'             1 = 1.00 Angstrom '
      print*,'             2 = 1.50 Angstrom '
      print*,'             3 = 2.00 Angstrom '
      print*,'-d           print debug information'
      print*,'-m 0         docking method, valid choices are:'
      print*,'             0 (HETATM based) and 1 (distance '
      print*,'             from center of HETATM based)'
      print*,'-q           requesting the Quality mode (takes longer)'
      print*,' '
      print*,'pdb_file     name of the pdbfile containing added'
      print*,'             hydrogens in the desired positions'
      print*,'             (amino acids only)'
      print*,' '
      print*,'             output docking poses in file dock.mol2'
      print*,' '

      return
      end

      subroutine getarg(i,line)
      parameter (maxarg=80)
      integer i,j
      character*80 words
      character*(*) line
      common /gargs/ words(maxarg)

      if (i.le.maxarg) line = words(i)    

      return
      end

      subroutine openfil(iun,filenm,lenfn,iform,iold,isil,isucc)
      implicit double precision (a-h,o-z)
      integer iun
      character*(*) filenm
      character*7 stat
      character*137 line

      isucc = 1

      if (iold.eq.1) then
          stat = 'old'
      else
          stat = 'unknown'
      endif

      if (lenfn.eq.0.or.filenm(1:lenfn).eq.' ') then
          print*,"Invalid Filename !"
          isucc = 0
      else
          close(iun)
          if (iform.eq.1) then
              open(unit=iun,form='formatted',file=filenm(1:lenfn),
     &               status=stat)
          else
             open(unit=iun,form='unformatted',file=filenm(1:lenfn),
     &               status=stat,err=100)
          endif
      endif

      return

100   if (isil.eq.0) then
         print*,'=',filenm,'='
         print*,"openfil: Error Opening File !"
      endif

      isucc = 0
      return
      end

      logical function opfil(iun,filenm,lenfn,iform,iold,isil)
      implicit double precision (a-h,o-z)
      character*(*) filenm
      character*7 stat

      opfil = .true.

      if (iold.eq.1) then
          stat = 'old'
      else
          stat = 'unknown'
      endif

      if (lenfn.eq.0.or.filenm.eq.' ') then
          print*,"Invalid Filename !"
          opfil = .false.
      else
          close(iun)
          if (iform.eq.1) then
             open(unit=iun,form='formatted',file=filenm,
     &               status=stat,err=100)
          else
             open(unit=iun,form='unformatted',file=filenm,
     &               status=stat,err=100)
          endif
      endif

      return

100   if (isil.eq.0) then
         print*,'=',filenm,'='
         print*,"opfil: Error Opening File !"
      endif

      opfil = .false.
      return
      end

      logical function gargpl(fl,n,strng1,strng2)
      integer n,fln
      character*(*) fl
      character*(*) strng1,strng2

      gargpl = .false.
       
      fln = len(fl)
      if (strng1(1:fln).ne.fl) return 
      if (strng1(fln+1:fln+1).eq.' ') then
           n = n + 1
           call getarg(n,strng2)
           if (strng2(1:1).eq.'-'.or.strng2(1:1).eq.' ') return
           strng2 = strng2(1:index(strng2,' ')-1)
      else
           strng2 = strng1(fln+1:index(strng1,' ')-1)
      endif
      gargpl = .true.

      return
      end

      subroutine proarg()
      implicit double precision (a-h,o-z)
      integer*4 getcwd,gstat
      character linput*256,argstr*75
      character ligfil*256
      character dckout*256
      character site*4
      character curdir*1024
      common /cwd/ curdir
      logical oempty,opfil,gargpl
      character fniun*256
      common /fnunit/ fniun
      common /rdwr/ iun1,iun2,iun3,iun4,iun5
      common /debug/ idebug

      ligfil = 'dock.xyz'
      dckout = 'dock.mol2'

      gstat = getcwd(curdir)

      if (gstat.ne.0) then
         print*,"could not get current working directory"
      else
         curdir(linlen(curdir)+1:linlen(curdir)+1) = char(0)
      endif

      iredir = 0
      nargs = iargc()
      call getarg(0,linput)
      call parsfn(linput,linlen(linput),20)

      ntargs = 0
      n = 0
      idebug = 0
      ifastsl = 1
      iqual = 0

      if (nargs.gt.0) then
1            n = n + 1
             call getarg(n,linput)
             if (linput(1:1).eq.'-') then

                if (gargpl('-r',n,linput,argstr)) then
                   ligfil = argstr
                   if (linlen(ligfil).eq.0) then
                      stop "Empty filename !"
                   endif
                   call parsfn(ligfil,linlen(ligfil),2)
                   if (opfil(47,ligfil,linlen(ligfil),1,1,0)) then
                      iun2 = 47
                   endif

                elseif (gargpl('-n',n,linput,argstr)) then
		   nsol = reada(argstr,1,len(argstr))
                   call parptr(0,fdum,fdum,nsol)
                elseif (gargpl('-h',n,linput,argstr)) then
                   if (len(argstr).eq.0) then
                      stop "No HETATM site defined !"
                   else
		      nligs = reada(argstr,1,len(argstr))
                      call parptr(1,fdum,fdum,nligs)
                   endif
                elseif (gargpl('-i',n,linput,argstr)) then
                   site = argstr
                   call parsfn(site,linlen(site),4)
                elseif (gargpl('-V',n,linput,argstr)) then
		   iqual = reada(argstr,1,len(argstr))
                   call parptr(4,fdum,fdum,iqual)
                elseif (linput(1:2) .eq. "-q") then
                   ifastsl = 0
                   call parptr(3,fdum,fdum,ifastsl)
                elseif (linput(1:2) .eq. "-d") then
		   idebug = 1
                else
                   call prtflg
                   stop
                endif

                goto 2
             else
                ntargs = ntargs + 1
             endif

             lenf = linlen(linput)
             fniun = linput(1:lenf)

             call parfns(fniun,lenf)

             if (nargs.eq.n) then
                ld = linlen(curdir)
                curdir = curdir(1:ld)//'/'
                ld = ld + 1
                if (fniun(1:1) == "/" ) then
                      if (opfil(48,fniun,lenf,1,1,0)) then
                         iun2 = 48
                         call parsfn(linput,lenf,0)
                      else
                         oempty = .true.
                         iftyp = 0
                      endif
                else
                      if (opfil(48,curdir(1:ld)//fniun,lenf+ld,1,1,0))
     &                then
                         iun2 = 48
                         call parsfn(linput,lenf,0)
                         call parstr(linput(1:4),11)
                      else
                         oempty = .true.
                         iftyp = 0
                      endif
                endif
             else
                if (iredir.eq.1) then
                   if (opfil(49,fniun,lenf,1,0,0)) iun3 = 49
                   return
                endif

                if (linput(1:2).eq.'> ') then
                   iredir = 1
                else
                   call parsfn(linput,lenf,0)
                endif
             endif
2            continue
          if (n.lt.nargs) goto 1
          if (ntargs.eq.0) oempty = .true.
      else
          oempty = .true.
      endif

      call parptr(2,fdum,fdum,idebug)

      return
      end

      subroutine clfort
      implicit double precision (a-h,o-z)
      common /rdwr/ iun1,iun2,iun3,iun4,iun5

      close(iun2)

      return
      end
