      subroutine vdwlj(ev,nac,iac,nad,iad,coo,iconn,ityp,forces,potscl)
      implicit double precision (a-h,o-z), integer (i-n)
      parameter (mxcon=10)
      parameter (mxac=3*mxcon)
      parameter (mxad=9*mxcon)
      parameter (mxamb=701)
      integer ambcls
      common /typpar/ ambchg(mxamb),ambcls(mxamb)
      parameter (mxcls=49)
      common /clspar/ ambvdwr(mxcls),ambvdwe(mxcls),mapagf(mxcls)
      parameter (mxgff=71)
      common /gftyp/  gfvdw(2,mxgff)
      common /limits/ cutvdw, cutchg
      common /athlp/  iatoms, mxnat
      integer*2 ityp
      dimension ded(3),vr(3)
      dimension coo(3,*),ityp(*),iconn(mxcon+1,*),
     &          forces(3,*),potscl(*),
     &          nac(*),nad(*),iac(mxac,*),iad(mxad,*)

      ev = 0.0d0
      cut2 = cutvdw * cutvdw
      v14sc = 0.5d0

      do i=1,iatoms-1

         i1 = int(ityp(i))
         if (i1.gt.0) then
            il = ambcls(i1)
            vdwr1 = ambvdwr(il)
            vdwe1 = ambvdwe(il)
         elseif (i1.le.0) then
            i1 = iabs(i1)
            vdwr1 = gfvdw(1,i1)
            vdwe1 = gfvdw(2,i1)
         endif

         do j=i+1,iatoms
            potscl(j) = 1.0d0
         end do

         do j=1,iconn(1,i)
            jj = iconn(j+1,i)
            if (jj.gt.0) then
               potscl(jj) = 0.0d0
            endif
         end do

         do j=1,nac(i)
            potscl(iac(j,i)) = 0.0d0
         end do

         do j=1,nad(i)
            potscl(iad(j,i)) = v14sc
         end do

         do k=i+1,iatoms

               do j=1,3
                  vr(j) = coo(j,i) - coo(j,k)
               end do

               rv2 = vr(1)*vr(1) + vr(2)*vr(2) + vr(3)*vr(3)

               if (rv2.le.cut2) then

c          [ (Rmin)**12       (Rmin)**6 ]
c e = eps  [ (----)     - 2.0 (----)    ]
c          [ ( r  )           ( r  )    ]

                  i2 = int(ityp(k))
                  if (i2.gt.0) then
                     kl = ambcls(i2)
                     vdwr2 = ambvdwr(kl)
                     vdwe2 = ambvdwe(kl)
                  elseif (i2.le.0) then
                     i2 = iabs(i2)
                     vdwr2 = gfvdw(1,i2)
                     vdwe2 = gfvdw(2,i2)
                  endif

c alternatively we could precalculate these vdwr(il,kl)
c                                           vdwe(il,kl)
                  rsum = vdwr1 + vdwr2
                  epsm = dsqrt(vdwe1 * vdwe2)

                  epsm = epsm * potscl(k)
                  rv   = dsqrt(rv2)
                  p6   = rsum**6 / rv2**3
                  p12  = p6 * p6

                  e    = epsm * (p12 - 2.0d0*p6)
                  de   = epsm * (p12 - p6) * (-12.0d0/rv)

                  de   = de / rv

                  do j=1,3
                     ded(j) = de * vr(j)
                  end do

                  ev   = ev + e

                  do j=1,3
                     forces(j,i) = forces(j,i) + ded(j)
                     forces(j,k) = forces(j,k) - ded(j)
                  end do

               end if
         end do
      end do

      return
      end
