c
c     Reading Frequencies TAPE21 Sections
c
c     ****************************************
c     Here are readed all ADF Frequencies data
c     ****************************************
c
      subroutine rwfreq(iu,jout)
c
      include 'tape21.fh'
      include 'general.fh'
      integer iu,jout
c
      integer nsymFR
      character symspFR*(lchars)
      dimension symspFR(nrepmx)
c
c     String defining ADF KF Section%SubSection
      character*(lchars) key
c
      integer isym,ndis,idis,nfrtot
      integer natmGEO
c
c
c
c     **********************
c     8. Section Frequencies
c     **********************
c
c
      nfrtot = 0
c
      if (runtype(1:8).eq.'FREQUENC') then
c
         key = 'Geometry%nr of atoms'
         call kfrdi(iu,key,natmGEO)
c
         key = 'Freq Symmetry%nr of symmetries'
         call kfrdi(iu,key,nsymFR)
c
         key = 'Freq Symmetry%symmetry labels'
         call kfrdns(iu,key,symspFR,nsymFR,1)
c
         do isym=1,nsymFR
            key = 
     &         'Freq Symmetry%nr of displacements_'//symspFR(isym)(1:10)
            call kfrdi(iu,key,ndis)
            key = 
     &           'Freq Symmetry%nr of rigids_'//symspFR(isym)(1:10)
            call kfrdi(iu,key,idis)
            ndis = ndis - idis
            nfrtot = nfrtot + ndis
c
         enddo
c     
         call compFR (iu,jout,nfrtot,nsymFR,symspFR,natmGEO)
      endif
c

c
      return
      end
c
c
      subroutine rwequFR(iu,jout,natmGEO)
c
      include 'tape21.fh'
      include 'general.fh'
      integer iu,j,natm,jout,i
      integer natmGEO
      character key*(lchars)
      double precision rwk1(natmx*3)
      double precision equFR(3,natmGEO)
c
c     common for atom nuclear charge
c
      double precision elec(natmx)
      common /nucharge/ elec
c
c     *******************************
c     Data Section for Atom label
c     Now here.
c     *******************************
c
      character*2 elemnt
      dimension elemnt(mxel)
c      common /elem/elemnt(mxel)
      data elemnt/' H','He',
     2 'Li','Be',' B',' C',' N',' O',' F','Ne',
     3 'Na','Mg','Al','Si',' P',' S','Cl','Ar',
     4 ' K','Ca','Sc','Ti',' V','Cr','Mn','Fe','Co','Ni','Cu',
     4 'Zn','Ga','Ge','As','Se','Br','Kr',
     5 'Rb','Sr',' Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag',
     5 'Cd','In','Sn','Sb','Te',' I','Xe',
     6 'Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy',
     6 'Ho','Er','Tm','Yb','Lu','Hf','Ta',' W','Re','Os','Ir','Pt',
     6 'Au','Hg','Tl','Pb','Bi','Po','At','Rn',
     7 'Fr','Ra','Ac','Th','Pa',' U','Np','Pu','Am','Cm','Bk','Cf',
     8 'XX','  '/
c     *******************************
c
c
      key = 'Freq%xyz'
      call kfrdnr(iu,key,rwk1,natmGEO*3,1)
      j = 0
c
c     Get XYZ for Frequencies
c
      do natm = 1, natmGEO
         equFR(1,natm) = rwk1(j+1)
         equFR(2,natm) = rwk1(j+2)
         equFR(3,natm) = rwk1(j+3)
         j = j + 3
      enddo
c
         call secwtit(jout,'FR-COORD',8,'AU',0)
c
c     Last change for atom labels in frequencies
c
c            write(jout,'(A2,1X,3F12.6)')
c     +        (namat(i),(equFR(j,i),j=1,3),i=1,nnuc)
c
            write(jout,'(A2,1X,3F12.6)')
     +        (elemnt(int(elec(i))),(equFR(j,i),j=1,3),i=1,nnuc)
c
      return
      end
c
c
      subroutine compFR(iu,jout,idimFR,nsymFR,symspFR,natmGEO)

      include 'tape21.fh'
      include 'general.fh'
      integer iu,jout
      integer natmGEO,k,j
      integer idimFR,nsymFR
      integer isym,idis,ndis,i
      integer nfrtot,nFR
      integer atmordGEO(natmGEO,2)
      integer iwk1(natmGEO*2)
      character key*(lchars)
      character symspFR*(lchars) 
      dimension symspFR(nrepmx)
      character chardummy*(lchars)
      character symfrlabel*(lchars)
      dimension symfrlabel(idimFR)
      double precision xyzFR(3,natmGEO,idimFR)
      double precision frequencies(maxnFR)
      double precision rwk1(3*natmGEO*idimFR),rwk2(idimFR*idimFR)
      logical logdummy
c
c
      logdummy = .true.
c
c
      key = 'Geometry%atom order index'
      call kfrdni(iu,key,iwk1,natmGEO*2,1)
c     
      do i = 1,natmGEO
         atmordGEO(i,1) = iwk1(i)
         atmordGEO(i,2) = iwk1(i+natmGEO)
      enddo
c
c
         nfrtot = 0
         nFR = 0
         do isym=1,nsymFR
            key = 
     &         'Freq Symmetry%nr of displacements_'//symspFR(isym)(1:10)
            call kfrdi(iu,key,ndis)
            key = 
     &           'Freq Symmetry%nr of rigids_'//symspFR(isym)(1:10)
            call kfrdi(iu,key,idis)
            ndis = ndis - idis
c
            if (ndis.gt.0) then
               key = 'Freq Symmetry%degeneracy_'//symspFR(isym)(1:10)
               call kfrdi(iu,key,i)
               if (i.eq.1) then
                  chardummy = symspFR(isym)
               else
                  i = index(symspFR(isym),':') - 1
                  chardummy = symspFR(isym)(1:i)
               endif
               key = 'Freq Symmetry%Frequencies_'//chardummy(1:10)
               call kfrdnr(iu,key,rwk1,ndis,1)
               do i = 1,ndis
                  frequencies(nFR+i) = rwk1(i)
               enddo
               nFR = nFR + ndis
c
c     *********************** RD FR START ******************************
c
               key = 
     &            'Freq Symmetry%displ_InputOrder_'//symspFR(isym)(1:10)
               call kfrdnr(iu,key,rwk1,3*natmGEO*ndis,1)
c     
               key = 'Freq Symmetry%NormalModes_'//chardummy(1:10)
               call kfrdnr(iu,key,rwk2,ndis*ndis,1)
c     
               do idis=1,ndis
                  k = 0
                  do j=1,natmGEO
                     xyzFR(1,atmordGEO(j,1),idis+nfrtot) = 0.0D00
                     xyzFR(2,atmordGEO(j,1),idis+nfrtot) = 0.0D00
                     xyzFR(3,atmordGEO(j,1),idis+nfrtot) = 0.0D00
                  enddo
                  do i=1,ndis
                     do j=1,natmGEO
                        symfrlabel(idis+nfrtot) = symspFR(isym)(1:10)
                        xyzFR(1,atmordGEO(j,1),idis+nfrtot) =
     &                       xyzFR(1,atmordGEO(j,1),idis+nfrtot) +
     &                       rwk1(k+1) * rwk2(i+(idis-1)*ndis)
                        xyzFR(2,atmordGEO(j,1),idis+nfrtot) = 
     &                       xyzFR(2,atmordGEO(j,1),idis+nfrtot) +
     &                       rwk1(k+2) * rwk2(i+(idis-1)*ndis)
                        xyzFR(3,atmordGEO(j,1),idis+nfrtot) = 
     &                       xyzFR(3,atmordGEO(j,1),idis+nfrtot) +
     &                       rwk1(k+3) * rwk2(i+(idis-1)*ndis)
                        k = k + 3
                     enddo
                  enddo
               enddo
      
      
c     *********************** RD FR END ********************************
c
               nfrtot = nfrtot + ndis
c
            endif
c
         enddo

c
c
c     ****************
c     Sort Frequencies
c     ****************
c
         do while (logdummy)
            logdummy = .false.
            do i=2,nFR
               if (frequencies(i-1).gt.frequencies(i)) then
                  logdummy = .true.
                  rwk1(1) = frequencies(i-1)
                  frequencies(i-1) = frequencies(i)
                  frequencies(i) = rwk1(1)
                  chardummy = symfrlabel(i-1)
                  symfrlabel(i-1) = symfrlabel(i)
                  symfrlabel(i) = chardummy
                  do k=1,nnuc
                     rwk1(1) = xyzFR(1,k,i-1)
                     rwk1(2) = xyzFR(2,k,i-1)
                     rwk1(3) = xyzFR(3,k,i-1)
                     xyzFR(1,k,i-1) = xyzFR(1,k,i)
                     xyzFR(2,k,i-1) = xyzFR(2,k,i)
                     xyzFR(3,k,i-1) = xyzFR(3,k,i)
                     xyzFR(1,k,i) = rwk1(1)
                     xyzFR(2,k,i) = rwk1(2)
                     xyzFR(3,k,i) = rwk1(3)
                  enddo
               endif
            enddo
         enddo
c
c
c     ******************
c     Frequencies Output
c     ******************
c
         call secwtit(jout,'FREQ',4,' ',0)
         do i=1,nFR
            write (jout,'(F10.4)') frequencies(i)
         enddo
c
         call rwequFR(iu,jout,natmGEO)
c
         call secwtit(jout,'FR-NORM-COORD',13,' ',0)
         do k=1,nFR
            write (jout,'(1X,A9,3X,I4,1X,A10)') 'vibration',k
     &           ,symfrlabel(k)
            write(jout,'(3(F12.6,1X))')
     +           ((xyzFR(j,i,k),j=1,3),i=1,nnuc)
         enddo
c
      end




