c
c     Reading Linear Transit TAPE21 Sections
c
c     *******************************************
c     Here are readed all ADF Linear Transit data
c     *******************************************
c
      subroutine rwlint(iu,jout)
c
      include 'tape21.fh'
      include 'general.fh'
      include 'lint.fh'
      integer iu,jout
c
      integer npLT,natm,j
      integer iLT,iNA
      double precision dummy
      dimension dummy(3*maxLTstep*natmx)
c
c
c     String defining ADF KF Section%SubSection
      character*(lchars) key
c
c
c     *************************
c     7. Section Linear Transit
c     *************************
c

      isLT = .false.
      if (runtype(1:14).eq.'LINEAR TRANSIT') then
         isLT = .true.
c         key = 'GeoOpt%nfree'
c         call kfrdi(iu,key,nfree)
c         key = 'GeoOpt%idfree'
c         call kfrdi(iu,key,idfree)
         key = 'LT%nr of points'
         call kfrdi(iu,key,npointLT)
         if (npointLT.gt.maxLTstep) then
            write (*,*) '  '
            Write (*,*) '  WARNING: Number of linear transit steps'//
     &           ' exceds Parameter Card'
            write (*,*) '  '
            write (*,*) '           Work Continue and set number of'//
     &           ' steps to:  ',maxLTstep
            write (*,*) '  '
            npointLT = maxLTstep
         endif
         key = 'LT%Energies'
         call kfrdnr(iu,key,energiesLT,npointLT,1)
         key = 'LT%Parameters'
         call kfrdnr(iu,key,ParametersLT,2,1)
         key = 'LT%atmcrd'
         call kfrds(iu,key,CoordTypeLT)
         key = 'LT%geocrd'
         call kfrds(iu,key,GeoCTypeLT)
         key = 'LT%xyz'
         call kfrdnr(iu,key,dummy,3*npointLT*nnuc,1)
         j=0
         do npLT=1,npointLT
            write (*,*) 'Step: ',npLT
            do natm=1,nnuc
               j=j+1
               xyzLT(1,natm,npLT) = dummy(j)
               j=j+1
               xyzLT(2,natm,npLT) = dummy(j)
               j=j+1
               xyzLT(3,natm,npLT) = dummy(j)
            enddo
         enddo
         key = 'LT%AtomCharge Mulliken'
         call kfrdnr(iu,key,dummy,npointLT*nnuc,1)
         write (*,*) (dummy(npLT),npLT=1,npointLT*nnuc)
      endif







c
c     *********************
c     Linear Transit Output
c     *********************
c
      if (isLT) then

c     writing LTENERG
c
         call secwtit(jout,'GEOCONV',7,' ',0)
         write (jout,'(A)') 'energy'
c
         do iLT=1,npointLT
            write (jout,'(1X,F10.4)') energiesLT(iLT)
         enddo
c         
c     Testing this
c      line=sqo//'LT-COORD'//sqc//' '//CoordTypeLT(1:4)
c      line=sqo//'LT-COORD'//sqc//' '//'XYZ'

         call secwtit(jout,'GEOMETRIES',10,'XYZ LinearTransit',17)
c
c     See the way to do this!!!!!
c
c      if (CoordTypeLT(1:3).eq.'XYZ'.or.CoordTypeLT(1:3).eq.'xyz') then


         do iLT=1,npointLT
c     write (jout,'(1X,I3)') iLT
            write (jout,'(1X,I3)') nnuc
            write (jout,'(1X,A10,1X,F10.4)')'sfc done:',energiesLT(iLT)
            do iNA=1,nnuc
               xyzLT(1,iNA,iLT) = 0.0529177D01 * xyzLT(1,iNA,iLT)
               xyzLT(2,iNA,iLT) = 0.0529177D01 * xyzLT(2,iNA,iLT)
               xyzLT(3,iNA,iLT) = 0.0529177D01 * xyzLT(3,iNA,iLT)
               write (jout,'(1X,A8,1X,3(F10.4,1X))')
     &              namat(iNA),(xyzLT(j,iNA,iLT),j=1,3)
            enddo
         enddo
         rewind (jout)
c
      endif
c
      return
      end
