c
c     ******************************************************************
c     Read General and Atoms Sections
c     And  write TITLE and CELL Section
c
c     ADFrom section are not the same of ADF TAPE21 Section
c     ******************************************************************
c
      subroutine rwgen(iu,jout)
c
      include 'tape21.fh'
      include 'general.fh'
      include 'comcoo.fh'
c
      integer iu,jout
c
c     String defining ADF KF Section%SubSection
      character*(lchars) key
c
c     Valence Electron
      double precision elecn
      character runtit*(lchars)
c
c     Dummy Declaretions
      integer i,k
      character cdummy*(lchars)
      double precision dbdummy(natmx*3)
      double precision ax,by,cz,al,bt,gm
      Data ax,by,cz,al,bt,gm/1.00,1.00,1.00,90.00,90.00,90.00/
c
c ----------------------------------------------------------------------
c     Section ADF General
c ----------------------------------------------------------------------
c
c     *******************
c     Write TITLE Section
c     *******************
c
      key = 'General%title'
      call kfrds(iu,key,runtit)
c
      call secwtit(jout,'Title',5,' ',0)
      write(jout,'(A)') runtit
      call  cifwrite(runtit)
c
c     ****************************
c     Write CELL parameter section
c     ****************************
c
      call secwtit(jout,'Cell',4,'Now not used',12)
      write(jout,'(6F10.3)') ax,by,cz,al,bt,gm
c
      key = 'General%nspin'
      call kfrdi(iu,key,nspin)
      key = 'General%electrons'
      call kfrdr(iu,key,elecn)
c
c Get Run Type
c
      key = 'General%runtype'
      call kfrds(iu,key,runtype)
c
c     ******************************
c     outputting header informations
c     ******************************
c
      write(cdummy,'(1X,A,A30)') '  Run Type: ',runtype
      call cifwrite(cdummy)
c
      if (nspin.eq.1) then
         write(cdummy,*)  '  Run Mode: ',' RESTRICTED CALCULATION'
      else
         write(cdummy,*)  '  Run Mode: ',' UNRESTRICTED CALCULATION '
      end if
      call cifwrite(cdummy)
c
      write(cdummy,'('' Valence Electrons: '',f8.2)') elecn
      call cifwrite(cdummy)
c
c ----------------------------------------------------------------------
c     Section Geometry
c ----------------------------------------------------------------------
c
      key = 'Geometry%nnuc'
      call kfrdi(iu,key,nnuc)
c
c      key = 'Geometry%grouplabel'
c      call kfrds(iu,key,grp)
c
      key = 'Geometry%xyz'
      call kfrdnr(iu,key,dbdummy,3*nnuc,1)
      i=0
      do k=1,nnuc
         coo(k,1)=dbdummy(i+1)
         coo(k,2)=dbdummy(i+2)
         coo(k,3)=dbdummy(i+3)
         i=i+3
      end do
c
      end



